/*
 * Decompiled with CFR 0.152.
 */
package io.github.abductcows.bitarray;

import io.github.abductcows.bitarray.CustomNonNullApi;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.RandomAccess;
import java.util.Spliterator;
import java.util.UnknownFormatConversionException;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import org.jetbrains.annotations.Contract;

@CustomNonNullApi
public final class BitArray
extends AbstractList<Boolean>
implements RandomAccess,
Cloneable {
    private static final int BITS_PER_LONG = 64;
    public static final int DEFAULT_CAPACITY = 64;
    private long[] data = new long[0];
    private int elements;

    public BitArray() {
        this(64);
    }

    public BitArray(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Array initial capacity is negative: " + initialCapacity);
        }
        this.initMembers(initialCapacity);
    }

    public BitArray(Collection<? extends Boolean> other) {
        if (other instanceof BitArray) {
            BitArray otherBitArray = (BitArray)other;
            int longsToCopy = this.longsRequiredForNBits(otherBitArray.elements);
            this.data = Arrays.copyOf(otherBitArray.data, longsToCopy);
            this.elements = otherBitArray.elements;
            return;
        }
        this.initMembers(other.size());
        this.addAll(other);
    }

    private void initMembers(int initialCapacity) {
        int sizeInLongs = this.longsRequiredForNBits(initialCapacity);
        this.data = new long[sizeInLongs];
        this.elements = 0;
    }

    @Override
    public void add(int index, Boolean bit) {
        this.ensureIndexInRange(index, this.elements);
        ++this.modCount;
        this.ensureCapacity();
        int longIndex = this.getLongIndex(index);
        int indexInLong = this.getIndexInLong(index);
        if (index == this.elements) {
            this.setBit(longIndex, indexInLong, bit);
            ++this.elements;
            return;
        }
        this.addAndShiftAllRight(bit, longIndex, indexInLong);
        ++this.elements;
    }

    @Override
    public boolean add(Boolean bit) {
        this.add(this.elements, bit);
        return true;
    }

    @Override
    public Boolean get(int index) {
        this.ensureIndexInRange(index, this.elements - 1);
        int longIndex = this.getLongIndex(index);
        int indexInLong = this.getIndexInLong(index);
        return this.getBit(longIndex, indexInLong);
    }

    @Override
    public Boolean set(int index, Boolean bit) {
        this.ensureIndexInRange(index, this.elements - 1);
        int longIndex = this.getLongIndex(index);
        int indexInLong = this.getIndexInLong(index);
        boolean oldBit = this.getBit(longIndex, indexInLong);
        this.setBit(longIndex, indexInLong, bit);
        return oldBit;
    }

    @Override
    public Boolean remove(int index) {
        this.ensureIndexInRange(index, this.elements - 1);
        ++this.modCount;
        int longIndex = this.getLongIndex(index);
        int indexInLong = this.getIndexInLong(index);
        boolean removedBit = this.getBit(longIndex, indexInLong);
        this.removeAndShiftAllLeft(longIndex, indexInLong);
        --this.elements;
        return removedBit;
    }

    @Override
    public int size() {
        return this.elements;
    }

    @Override
    public void clear() {
        ++this.modCount;
        this.initMembers(64);
    }

    private int getLongIndex(int bitIndex) {
        return bitIndex / 64;
    }

    private int getIndexInLong(int bitIndex) {
        return bitIndex % 64;
    }

    private void setBit(int longIndex, int indexInLong, boolean bit) {
        if (bit) {
            int n = longIndex;
            this.data[n] = this.data[n] | this.singleBitMask(indexInLong);
            return;
        }
        int n = longIndex;
        this.data[n] = this.data[n] & (this.singleBitMask(indexInLong) ^ 0xFFFFFFFFFFFFFFFFL);
    }

    private void addAndShiftAllRight(boolean bit, int longIndex, int indexInLong) {
        int maxLongIndex = this.getLongIndex(this.elements);
        int bitIntValue = Boolean.compare(bit, Boolean.FALSE);
        long rightmostBit = this.insertInLong(bitIntValue, 1, longIndex++, indexInLong);
        while (longIndex <= maxLongIndex) {
            rightmostBit = this.insertInLong(rightmostBit, 1, longIndex++, 0);
        }
    }

    private long insertInLong(long lastValue, int lastLength, int longIndex, int indexInLong) {
        long rightSide = this.data[longIndex] << indexInLong >>> indexInLong;
        long leftSide = this.data[longIndex] & (rightSide ^ 0xFFFFFFFFFFFFFFFFL);
        long rightSideShiftOut = this.selectBits(rightSide, 64 - lastLength, lastLength);
        rightSide >>>= lastLength;
        this.data[longIndex] = leftSide ^ (rightSide |= lastValue << 64 - lastLength - indexInLong);
        return rightSideShiftOut;
    }

    private void removeAndShiftAllLeft(int longIndex, int indexInLong) {
        int currentLongIndex = this.getLongIndex(this.elements - 1);
        long leftmostBit = 0L;
        while (currentLongIndex > longIndex) {
            leftmostBit = this.removeAtIndexAndAppend(leftmostBit, 1, currentLongIndex--, 0);
        }
        this.removeAtIndexAndAppend(leftmostBit, 1, longIndex, indexInLong);
    }

    private long removeAtIndexAndAppend(long lastValue, int lastLength, int longIndex, int indexInLong) {
        long rightSide = this.data[longIndex] << indexInLong >>> indexInLong;
        long leftSide = this.data[longIndex] & (rightSide ^ 0xFFFFFFFFFFFFFFFFL);
        long poppedValues = this.selectBits(rightSide, indexInLong, lastLength) >>> 64 - indexInLong - lastLength;
        rightSide = rightSide << indexInLong + lastLength >>> indexInLong;
        this.data[longIndex] = leftSide ^ (rightSide |= lastValue);
        return poppedValues;
    }

    private long selectBits(long aLong, int start, int length) {
        long mask = Long.MIN_VALUE >>> start;
        mask |= (Long.MIN_VALUE >>> start) - 1L;
        return aLong & (mask &= -(Long.MIN_VALUE >>> start + length - 1));
    }

    private void ensureIndexInRange(int index, int endInclusive) {
        if (index < 0 || index > endInclusive) {
            throw new IndexOutOfBoundsException("Array index " + index + " out of bounds for array size " + this.size());
        }
    }

    private boolean getBit(int longIndex, int indexInLong) {
        int bit = this.getBitInLong(this.data[longIndex], indexInLong);
        return bit != 0;
    }

    private void ensureCapacity() {
        if (this.elements == Integer.MAX_VALUE) {
            throw new IllegalStateException("Cannot insert; array is completely full. Size = " + this.size());
        }
        if (this.elements == this.data.length * 64) {
            this.doubleSize();
        }
    }

    private void doubleSize() {
        int newSize = (int)Math.min(2L * (long)this.elements, Integer.MAX_VALUE);
        this.resize(newSize);
    }

    private void resize(int newSize) {
        if (newSize == 0) {
            this.initMembers(64);
            return;
        }
        int newSizeInLongs = this.longsRequiredForNBits(newSize);
        this.data = Arrays.copyOf(this.data, newSizeInLongs);
        this.elements = Math.min(this.elements, newSize);
    }

    long singleBitMask(int bitIndex) {
        return Long.MIN_VALUE >>> bitIndex;
    }

    private int getBitInLong(long theLong, int bitIndex) {
        return (int)(theLong >> 63 - bitIndex) & 1;
    }

    private int longsRequiredForNBits(int nBits) {
        return (int)Math.ceil((double)nBits / 64.0);
    }

    public int countOnes() {
        if (this.isEmpty()) {
            return 0;
        }
        int oneCount = 0;
        int limit = this.longsRequiredForNBits(this.size()) - 1;
        for (int i = 0; i < limit; ++i) {
            oneCount += Long.bitCount(this.data[i]);
        }
        int remainingBits = this.elements - limit * 64;
        for (int i = 0; i < remainingBits; ++i) {
            if (!this.getBit(limit, i)) continue;
            ++oneCount;
        }
        return oneCount;
    }

    public int countZeros() {
        return this.size() - this.countOnes();
    }

    public int indexOfNeedle(boolean needle) {
        long indifferentLongFormat = needle ? 0L : -1L;
        int longIndexLimit = this.longsRequiredForNBits(this.size()) - 1;
        for (int longIndex = 0; longIndex < longIndexLimit && this.data[longIndex] == indifferentLongFormat; ++longIndex) {
        }
        for (int i = longIndex * 64; i < this.elements; ++i) {
            if (!this.get(i).equals(needle)) continue;
            return i;
        }
        return -1;
    }

    @Contract(value=" -> new")
    public BitArray clone() {
        return new BitArray(this);
    }

    @Override
    public String toString() {
        StringBuilder s = new StringBuilder(this.size() * 2 + 10);
        s.append("Size = ").append(this.size()).append(", ");
        s.append('[');
        for (int i = 0; i < this.size() - 1; ++i) {
            s.append(Boolean.compare(this.get(i), Boolean.FALSE));
            s.append(' ');
        }
        if (this.size() > 0) {
            s.append(Boolean.compare(this.get(this.size() - 1), Boolean.FALSE));
        }
        s.append(']');
        return s.toString();
    }

    public static BitArray fromString(String stringArray) {
        String start = "Size = ";
        if (!stringArray.startsWith("Size = ")) {
            throw new UnknownFormatConversionException("Not a valid BitArray string");
        }
        int currentIndex = stringArray.indexOf(",", "Size = ".length());
        try {
            String arraySizeStr = stringArray.substring("Size = ".length(), currentIndex);
            int arraySize = Integer.parseInt(arraySizeStr);
            currentIndex += ", [".length();
            List<Character> allowedElements = List.of(Character.valueOf('0'), Character.valueOf('1'));
            BitArray result = new BitArray(arraySize);
            for (int i = 0; i < arraySize; ++i) {
                char current = stringArray.charAt(currentIndex);
                if (currentIndex >= stringArray.length() - 1 || !allowedElements.contains(Character.valueOf(current))) {
                    throw new UnknownFormatConversionException("Not a valid BitArray string");
                }
                result.add(current == '1');
                currentIndex += 2;
            }
            return result;
        }
        catch (IndexOutOfBoundsException | NumberFormatException e) {
            throw new UnknownFormatConversionException("Not a valid BitArray string");
        }
    }

    @Override
    public int indexOf(Object o) {
        return super.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return super.lastIndexOf(o);
    }

    @Override
    public boolean addAll(int index, Collection<? extends Boolean> c) {
        return super.addAll(index, c);
    }

    @Override
    public Iterator<Boolean> iterator() {
        return super.iterator();
    }

    @Override
    public ListIterator<Boolean> listIterator() {
        return super.listIterator();
    }

    @Override
    public ListIterator<Boolean> listIterator(int index) {
        return super.listIterator(index);
    }

    @Override
    public List<Boolean> subList(int fromIndex, int toIndex) {
        return super.subList(fromIndex, toIndex);
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    protected void removeRange(int fromIndex, int toIndex) {
        super.removeRange(fromIndex, toIndex);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return super.contains(o);
    }

    public Boolean[] toArray() {
        return this.toArray(new Boolean[this.size()]);
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return super.toArray(a);
    }

    @Override
    public <T> T[] toArray(IntFunction<T[]> generator) {
        return super.toArray(generator);
    }

    @Override
    public boolean remove(Object o) {
        return super.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return super.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends Boolean> c) {
        return super.addAll(c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return super.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return super.retainAll(c);
    }

    @Override
    public void replaceAll(UnaryOperator<Boolean> operator) {
        super.replaceAll(operator);
    }

    @Override
    public void sort(Comparator<? super Boolean> c) {
        super.sort(c);
    }

    @Override
    public Spliterator<Boolean> spliterator() {
        return super.spliterator();
    }

    @Override
    public boolean removeIf(Predicate<? super Boolean> filter) {
        return super.removeIf(filter);
    }

    @Override
    public Stream<Boolean> stream() {
        return super.stream();
    }

    @Override
    public Stream<Boolean> parallelStream() {
        return super.parallelStream();
    }

    @Override
    public void forEach(Consumer<? super Boolean> action) {
        for (Boolean b : this) {
            action.accept(b);
        }
    }
}

