/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.leeds.ccg.ukpc;

public class UKPC_Checker {
    public static final int TYPE_AANN = 1;
    public static final int TYPE_AANA = 2;
    public static final int TYPE_ANN = 3;
    public static final int TYPE_ANA = 4;
    public static final int TYPE_AAN = 5;
    public static final int TYPE_AAA = 6;
    public static final int TYPE_AN = 7;
    public static final char[] AtoZ = "ABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();
    public static final char[] AtoZ_not_CIKMOV = "ABDEFGHJKLNPQRSTUWXYZ".toCharArray();
    public static final char[] AtoZ_not_QVX = "ABCDEFGHIJKLMNOPRSTUWYZ".toCharArray();
    public static final char[] AtoZ_not_IJZ = "ABCDEFGHKLMNOPQRSTUVWXY".toCharArray();
    public static final char[] ABCDEFGHJKSTUW = "ABCDEFGHJKSTUW".toCharArray();
    public static final char[] ABEHMNPRVWXY = "ABEHMNPRVWXY".toCharArray();
    public static final char[] digits = "0123456789".toCharArray();

    public boolean isValidPostcodeArea(String s) {
        if (s == null) {
            return false;
        }
        int length = s.length();
        if (length < 2) {
            return false;
        }
        if (length > 3) {
            return false;
        }
        char[] chars = s.toCharArray();
        if (this.contains(chars[0], AtoZ_not_QVX)) {
            if (length == 1) {
                return true;
            }
            if (this.contains(chars[1], AtoZ_not_IJZ)) {
                return true;
            }
        }
        return false;
    }

    public boolean isValidPostcodeDistrict(String s) {
        if (s == null) {
            return false;
        }
        int length = s.length();
        if (length < 2) {
            return false;
        }
        int fppt = this.getFirstPartPostcodeType(s.toCharArray());
        return fppt != 0;
    }

    public boolean isValidPostcodeSector(String s) {
        if (s == null) {
            return false;
        }
        int length = s.length();
        if (length < 3) {
            return false;
        }
        if (this.contains(s.substring(length - 1, length).toCharArray()[0], digits)) {
            char[] fpp = s.substring(0, length - 1).toCharArray();
            int fppt = this.getFirstPartPostcodeType(fpp);
            return fppt != 0;
        }
        return false;
    }

    public boolean isValidPostcodeUnit(String s) {
        if (s == null) {
            return false;
        }
        int length = s.length();
        if (length < 5) {
            return false;
        }
        if (this.isValidSecondPartUnitPostcode(s.substring(length - 3, length).toCharArray())) {
            char[] fpp = s.substring(0, length - 3).toCharArray();
            int fppt = this.getFirstPartPostcodeType(fpp);
            return fppt != 0;
        }
        if (this.isValidSecondPartUnitPostcodeOld(s.substring(length - 3, length).toCharArray())) {
            char[] fpp = s.substring(0, length - 3).toCharArray();
            int fppt = this.getFirstPartPostcodeType(fpp);
            return fppt != 0;
        }
        return false;
    }

    public int getUnitPostcodeType(String s) {
        if (this.isValidPostcodeUnit(s)) {
            return this.getUnitPostcodeType(s, s.length());
        }
        return 0;
    }

    public int getUnitPostcodeType(String s, int length) {
        if (length < 5) {
            return 0;
        }
        String spp = s.substring(length - 3, length);
        if (this.isValidSecondPartUnitPostcode(spp.toCharArray())) {
            return this.getFirstPartPostcodeType(s.substring(0, length - 3).toCharArray());
        }
        return 0;
    }

    public int getPostcodeSectorType(String s, int length) {
        if (length < 4) {
            return 0;
        }
        String spp = s.substring(length - 1, length);
        if (this.contains(spp.toCharArray()[0], digits)) {
            return this.getFirstPartPostcodeType(s.substring(0, length - 1).toCharArray());
        }
        return 0;
    }

    public boolean isValidSecondPartUnitPostcode(char[] spp) {
        return spp.length == 3 && this.contains(spp[0], digits) && this.contains(spp[1], AtoZ_not_CIKMOV) && this.contains(spp[2], AtoZ_not_CIKMOV);
    }

    public boolean isValidSecondPartUnitPostcodeOld(char[] spp) {
        return spp.length == 3 && this.contains(spp[0], digits) && this.contains(spp[1], AtoZ) && this.contains(spp[2], AtoZ);
    }

    public int getFirstPartPostcodeType(char[] fpp) {
        if (fpp.length > 4 || fpp.length < 2) {
            return 0;
        }
        if (fpp.length == 4) {
            if (this.contains(fpp[0], AtoZ_not_QVX) && this.contains(fpp[1], AtoZ_not_IJZ) && this.contains(fpp[2], digits) && this.contains(fpp[3], digits)) {
                return 1;
            }
            if (this.contains(fpp[0], AtoZ_not_QVX) && this.contains(fpp[1], AtoZ_not_IJZ) && this.contains(fpp[2], digits) && this.contains(fpp[3], ABEHMNPRVWXY)) {
                return 2;
            }
            return 0;
        }
        if (fpp.length == 3) {
            if (this.contains(fpp[0], AtoZ_not_QVX)) {
                if (this.contains(fpp[1], digits)) {
                    if (this.contains(fpp[2], digits)) {
                        return 3;
                    }
                    if (this.contains(fpp[2], ABCDEFGHJKSTUW)) {
                        return 4;
                    }
                    if (fpp[2] == 'P') {
                        return 4;
                    }
                    if (fpp[0] == 'W') {
                        if (this.contains(fpp[2], AtoZ)) {
                            return 4;
                        }
                        return 0;
                    }
                    if (fpp[2] == 'N') {
                        return 4;
                    }
                    return 0;
                }
                if (this.contains(fpp[1], AtoZ_not_IJZ)) {
                    if (this.contains(fpp[2], digits)) {
                        return 5;
                    }
                    if (fpp[1] == 'P' && fpp[2] == 'T') {
                        return 6;
                    }
                    if (fpp[1] == 'R' && fpp[2] == 'O') {
                        return 6;
                    }
                    return 0;
                }
                if (fpp[1] == 'I' && fpp[2] == 'R') {
                    return 6;
                }
                return 0;
            }
            return 0;
        }
        if (fpp.length == 2 && this.contains(fpp[0], AtoZ_not_QVX) && this.contains(fpp[1], digits)) {
            return 7;
        }
        return 0;
    }

    public boolean contains(char c, char[] a) {
        for (char x : a) {
            if (x != c) continue;
            return true;
        }
        return false;
    }
}

