/*
 * Decompiled with CFR 0.152.
 */
package io.github.albertopires.mail;

import io.github.albertopires.commons.GenericProperties;
import io.github.albertopires.mail.Mail;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import javax.mail.MessagingException;
import javax.mail.internet.AddressException;

public class Example {
    public static void main(String[] args) throws AddressException, MessagingException, UnsupportedEncodingException, IOException {
        String userId = System.getProperty("userId");
        String password = System.getProperty("password");
        if (args.length >= 6) {
            int i;
            GenericProperties param = new GenericProperties();
            ArrayList<String> rcptList = new ArrayList<String>();
            Mail mail = userId != null ? new Mail(userId, password) : new Mail();
            if (args[0].equals("-t")) {
                param.put("file.message", args[1]);
                param.put("mail.from", args[2]);
                param.put("mail.from.name", args[3]);
                param.put("mail.subject", args[4]);
                for (i = 5; i < args.length; ++i) {
                    rcptList.add(args[i]);
                }
                param.put("rcpt.list", rcptList);
                mail.sendTextMail(param);
                System.exit(0);
            }
            if (args[0].equals("-f")) {
                param.put("file.attachment", args[1]);
                param.put("mail.from", args[2]);
                param.put("mail.from.name", args[3]);
                param.put("mail.subject", args[4]);
                for (i = 5; i < args.length; ++i) {
                    rcptList.add(args[i]);
                }
                param.put("rcpt.list", rcptList);
                mail.sendTextandAttachmentEmail(param);
                System.exit(0);
            }
            if (args[0].equals("-m")) {
                param.put("file.message", args[1]);
                param.put("file.attachment", args[2]);
                param.put("mail.from", args[3]);
                param.put("mail.from.name", args[4]);
                param.put("mail.subject", args[5]);
                for (i = 6; i < args.length; ++i) {
                    rcptList.add(args[i]);
                }
                param.put("rcpt.list", rcptList);
                mail.sendTextandAttachmentEmail(param);
                System.exit(0);
            }
        } else {
            System.out.println("Send Mail/File\n");
            System.err.println("Invalid parameters.");
            System.err.println("-t : send text message.");
            System.err.println("-f : send attached file");
            System.err.println("-m : send text message with attached file");
            System.err.println();
            System.err.println("-t <msg.txt> <from> <from_name> <subject> <rcpt1> <rcpt2> ... <rcptN>");
            System.err.println("-f <file.any_type> <from> <from_name> <subject> <rcpt1> <rcpt2> ... <rcptN>");
            System.err.println("-m <msg.txt> <file.any_type> <from> <from_name> <subject> <rcpt1> <rcpt2> ... <rcptN>");
        }
    }
}

