package amk.sdk.deeplink;

import amk.sdk.deeplink.entity.model.AMKDLIndividual;
import amk.sdk.deeplink.entity.model.AMKDLMerchant;
import amk.sdk.deeplink.entity.model.AMKDLStatus;
import amk.sdk.deeplink.entity.model.AMKDeeplinkData;
import amk.sdk.deeplink.exception.DeeplinkException;
import amk.sdk.deeplink.entity.response.AMKDLResponse;
import amk.sdk.deeplink.presenter.DeeplinkPresenter;

import static amk.sdk.deeplink.entity.model.AMKDLValidation.*;

public class AMKDeeplink {

    private final static int ERROR_CODE = 1;

    public AMKDeeplink(String clientId, String privateKeyPath, String jwtAudience) {
        DeeplinkPresenter.preConfig(clientId, privateKeyPath, jwtAudience);
    }

    public AMKDLResponse<AMKDeeplinkData> generateIndividualDeeplink(AMKDLIndividual AMKDLIndividual) {

        try {
            return DeeplinkPresenter.generateIndividualDeeplink(getValidIndividual(AMKDLIndividual));
        } catch (DeeplinkException exception) {
            return responseError(exception);
        }
    }

    AMKDLResponse<AMKDeeplinkData> generateMerchantDeeplink(AMKDLMerchant amkdlMerchant) {

        try {
            return DeeplinkPresenter.generateMerchantDeeplink(getValidMerchant(amkdlMerchant));
        } catch (DeeplinkException exception) {
            return responseError(exception);
        }
    }

    private static AMKDLIndividual getValidIndividual(AMKDLIndividual amkdlIndividual) throws DeeplinkException {

        amk.sdk.deeplink.entity.model.AMKDLIndividual validAMKDLIndividual = new AMKDLIndividual();
        validAMKDLIndividual.setAccountId(getAccountId(amkdlIndividual.getAccountId()));
        validAMKDLIndividual.setReferenceId(getReferenceId(amkdlIndividual.getReferenceId(), amkdlIndividual.getAccountId()));
        validAMKDLIndividual.setMerchantName(getMerchantName(amkdlIndividual.getMerchantName()));
        validAMKDLIndividual.setAMKDLCurrency(getCurrencyType(amkdlIndividual.getAMKDLCurrency()));
        validAMKDLIndividual.setAmount(getAmount(amkdlIndividual.getAmount(), amkdlIndividual.getAMKDLCurrency()));
        validAMKDLIndividual.setMobileNumber(getMobileNumber(amkdlIndividual.getMobileNumber()));
        validAMKDLIndividual.setBillNumber(getBillNumber(amkdlIndividual.getBillNumber()));
        validAMKDLIndividual.setStoreLabel(getStoreLabel(amkdlIndividual.getStoreLabel()));
        validAMKDLIndividual.setTerminalLabel(getTerminalLabel(amkdlIndividual.getTerminalLabel()));

        return validAMKDLIndividual;
    }

    private static AMKDLMerchant getValidMerchant(AMKDLMerchant amkdlMerchant) throws DeeplinkException {
        AMKDLMerchant validAMKDLMerchant = new AMKDLMerchant();
        validAMKDLMerchant.setMerchantId(getMerchantId(amkdlMerchant.getMerchantId()));
        validAMKDLMerchant.setReferenceId(getReferenceId(amkdlMerchant.getReferenceId(), amkdlMerchant.getMerchantId()));
        validAMKDLMerchant.setMerchantName(getMerchantName(amkdlMerchant.getMerchantName()));
        validAMKDLMerchant.setAMKDLCurrency(getCurrencyType(amkdlMerchant.getAMKDLCurrency()));
        validAMKDLMerchant.setAmount(getAmount(amkdlMerchant.getAmount(), amkdlMerchant.getAMKDLCurrency()));
        validAMKDLMerchant.setMobileNumber(getMobileNumber(amkdlMerchant.getMobileNumber()));
        validAMKDLMerchant.setBillNumber(getBillNumber(amkdlMerchant.getBillNumber()));
        validAMKDLMerchant.setStoreLabel(getStoreLabel(amkdlMerchant.getStoreLabel()));
        validAMKDLMerchant.setTerminalLabel(getTerminalLabel(amkdlMerchant.getTerminalLabel()));
        validAMKDLMerchant.setSourceInfo(getSourceInfo(amkdlMerchant.getSourceInfo()));

        return validAMKDLMerchant;
    }

    private static AMKDLResponse<AMKDeeplinkData> responseError(DeeplinkException exception) {
        AMKDLResponse<AMKDeeplinkData> response = new AMKDLResponse<AMKDeeplinkData>();
        AMKDLStatus status = new AMKDLStatus();

        status.setCode(ERROR_CODE);
        status.setErrorCode(exception.getErrorCode());
        status.setMessage(exception.getMessage());
        response.setStatus(status);

        return response;
    }

}
