package amk.sdk.deeplink.entity.model;

import java.util.HashMap;

public class AMKDLErrorCode {

    public static final int ACCOUNT_ID_REQUIRED = 1;
    public static final int ACCOUNT_ID_INVALID = 2;
    public static final int ACCOUNT_ID_LENGTH_INVALID = 3;
    public static final int MERCHANT_NAME_REQUIRED = 4;
    public static final int MERCHANT_NAME_LENGTH_INVALID = 5;
    public static final int CURRENCY_TYPE_REQUIRED = 6;
    public static final int AMOUNT_INVALID = 7;
    public static final int MOBILE_NUMBER_LENGTH_INVALID = 8;
    public static final int BILL_NUMBER_LENGTH_INVALID = 9;
    public static final int STORE_LABEL_LENGTH_INVALID = 10;
    public static final int TERMINAL_LABEL_LENGTH_INVALID = 11;
    public static final int MERCHANT_ID_REQUIRED = 12;
    public static final int MERCHANT_ID_LENGTH_INVALID = 13;
    public static final int SOURCE_INFO_INVALID = 14;
    public static final int NO_INTERNET_CONNECTION = 15;
    public static final int SOMETHING_WENT_WRONG = 16;
    public static final int FILE_NOT_EXIST = 17;
    public static final int WRONG_CONFIG = 18;




    public static final HashMap<Integer, String> errorCodeMap = new HashMap<Integer, String>() {
        {
            put(ACCOUNT_ID_REQUIRED, "Account ID cannot be null or empty");
            put(ACCOUNT_ID_INVALID, "Account ID is invalid");
            put(ACCOUNT_ID_LENGTH_INVALID, "Account ID Length is invalid");
            put(MERCHANT_NAME_REQUIRED, "Merchant Name cannot be null or empty");
            put(MERCHANT_NAME_LENGTH_INVALID, "Merchant Name Length is invalid");
            put(CURRENCY_TYPE_REQUIRED, "Currency type cannot be null or empty");
            put(AMOUNT_INVALID, "Amount is invalid");
            put(MOBILE_NUMBER_LENGTH_INVALID, "Mobile Number Length is invalid");
            put(BILL_NUMBER_LENGTH_INVALID, "Bill Number Length is invalid");
            put(STORE_LABEL_LENGTH_INVALID, "Store Label Length is invalid");
            put(TERMINAL_LABEL_LENGTH_INVALID, "Terminal Label Length is invalid");
            put(MERCHANT_ID_REQUIRED,  "Merchant ID cannot be null or empty");
            put(MERCHANT_ID_LENGTH_INVALID, "Merchant ID Length is invalid");
            put(SOURCE_INFO_INVALID, "Source Info is invalid");
            put(NO_INTERNET_CONNECTION, "Please check internet connection");
            put(SOMETHING_WENT_WRONG, "Something went wrong");
            put(FILE_NOT_EXIST, "File doesn't exist");
            put(WRONG_CONFIG, "Provided config info is invalid");
        }
    };
}
