package amk.sdk.deeplink.presenter;

import amk.sdk.deeplink.entity.response.OAuthTokenResponse;
import amk.sdk.deeplink.utils.StringUtils;
import com.google.gson.Gson;
import okhttp3.*;

import static amk.sdk.deeplink.entity.model.ApiConstant.*;

class AuthenticationPresenter {

    static String getAccessToken(String clientId, String privateKeyPath, String jwtAudience) throws Exception {
        String jwtToken = JwtTokenConfigPresenter.generateJwtToken(clientId, privateKeyPath, jwtAudience);
        String endpoint = "/api/v1/common/oauth/token";
        OkHttpClient client = new OkHttpClient().newBuilder()
                .build();
        MediaType mediaType = MediaType.parse("application/x-www-form-urlencoded");
        RequestBody body = RequestBody.create(mediaType, "grant_type=" + GRANT_TYPE + "&assertion=" + jwtToken);
        Request request = new Request.Builder()
                .url(BASE_URL + endpoint)
                .method("POST", body)
                .build();
        Response response = client.newCall(request).execute();

        Gson gson = new Gson();
        OAuthTokenResponse oAuthTokenResponse;
        ResponseBody responseBody = response.body();
        if (response.isSuccessful() & responseBody != null) {
            String json = responseBody.string();
            oAuthTokenResponse = gson.fromJson(
                    json,
                    OAuthTokenResponse.class
            );
            if (StringUtils.isBlank(oAuthTokenResponse.getAccess_token())) {
                return null;
            } else {
                return oAuthTokenResponse.getAccess_token();
            }
        }
        return null;
    }
}
