/*
 * Decompiled with CFR 0.152.
 */
package amk.sdk.deeplink.presenter;

import amk.sdk.deeplink.exception.DeeplinkException;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.Key;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Base64;
import java.util.Date;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class JwtTokenConfigPresenter {
    private static final long JWT_TOKEN_VALIDITY = 300000L;

    public static String generateJwtToken(String clientId, String privateKeyPath, String jwtAudience) throws Exception {
        long nowMillis = System.currentTimeMillis();
        Date now = new Date(nowMillis);
        long expired = nowMillis + 300000L;
        Date exp = new Date(expired);
        return Jwts.builder().setIssuer(clientId).setAudience(jwtAudience).setIssuedAt(now).setExpiration(exp).signWith(SignatureAlgorithm.RS256, (Key)JwtTokenConfigPresenter.getPrivateKey(privateKeyPath)).compact();
    }

    private static PrivateKey getPrivateKey(String fileName) throws Exception {
        File file = new File(fileName);
        if (!file.exists()) {
            DeeplinkException.throwCustomerException(17);
        }
        String privateKeyString = new String(Files.readAllBytes(Paths.get(fileName, new String[0])));
        String replacePrivateKeyString = privateKeyString.replaceAll(System.lineSeparator(), "").replace("-----BEGIN RSA PRIVATE KEY-----", "").replace("-----END RSA PRIVATE KEY-----", "").replace("-----BEGIN PRIVATE KEY-----", "").replace("-----END PRIVATE KEY-----", "");
        KeyFactory fact = KeyFactory.getInstance("RSA", BouncyCastleProvider.PROVIDER_NAME);
        byte[] bytes = Base64.getDecoder().decode(replacePrivateKeyString.getBytes(StandardCharsets.UTF_8));
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(bytes);
        return fact.generatePrivate(keySpec);
    }
}

