/*
 * Decompiled with CFR 0.152.
 */
package amk.sdk.deeplink;

import amk.sdk.deeplink.entity.model.AMKDLIndividual;
import amk.sdk.deeplink.entity.model.AMKDLMerchant;
import amk.sdk.deeplink.entity.model.AMKDLStatus;
import amk.sdk.deeplink.entity.model.AMKDLValidation;
import amk.sdk.deeplink.entity.model.AMKDeeplinkData;
import amk.sdk.deeplink.entity.response.AMKDLResponse;
import amk.sdk.deeplink.exception.DeeplinkException;
import amk.sdk.deeplink.presenter.DeeplinkPresenter;

public class AMKDeeplink {
    private static final int ERROR_CODE = 1;

    public AMKDeeplink(String clientId, String privateKeyPath, String jwtAudience) {
        DeeplinkPresenter.preConfig(clientId, privateKeyPath, jwtAudience);
    }

    public AMKDLResponse<AMKDeeplinkData> generateIndividualDeeplink(AMKDLIndividual AMKDLIndividual2) {
        try {
            return DeeplinkPresenter.generateIndividualDeeplink(AMKDeeplink.getValidIndividual(AMKDLIndividual2));
        }
        catch (DeeplinkException exception) {
            return AMKDeeplink.responseError(exception);
        }
    }

    public AMKDLResponse<AMKDeeplinkData> generateMerchantDeeplink(AMKDLMerchant amkdlMerchant) {
        try {
            return DeeplinkPresenter.generateMerchantDeeplink(AMKDeeplink.getValidMerchant(amkdlMerchant));
        }
        catch (DeeplinkException exception) {
            return AMKDeeplink.responseError(exception);
        }
    }

    private static AMKDLIndividual getValidIndividual(AMKDLIndividual amkdlIndividual) throws DeeplinkException {
        AMKDLIndividual validAMKDLIndividual = new AMKDLIndividual();
        validAMKDLIndividual.setAccountId(AMKDLValidation.getAccountId(amkdlIndividual.getAccountId()));
        validAMKDLIndividual.setReferenceId(AMKDLValidation.getReferenceId(amkdlIndividual.getReferenceId(), amkdlIndividual.getAccountId()));
        validAMKDLIndividual.setMerchantName(AMKDLValidation.getMerchantName(amkdlIndividual.getMerchantName()));
        validAMKDLIndividual.setAMKDLCurrency(AMKDLValidation.getCurrencyType(amkdlIndividual.getAMKDLCurrency()));
        validAMKDLIndividual.setAmount(AMKDLValidation.getAmount(amkdlIndividual.getAmount(), amkdlIndividual.getAMKDLCurrency()));
        validAMKDLIndividual.setMobileNumber(AMKDLValidation.getMobileNumber(amkdlIndividual.getMobileNumber()));
        validAMKDLIndividual.setBillNumber(AMKDLValidation.getBillNumber(amkdlIndividual.getBillNumber()));
        validAMKDLIndividual.setStoreLabel(AMKDLValidation.getStoreLabel(amkdlIndividual.getStoreLabel()));
        validAMKDLIndividual.setTerminalLabel(AMKDLValidation.getTerminalLabel(amkdlIndividual.getTerminalLabel()));
        return validAMKDLIndividual;
    }

    private static AMKDLMerchant getValidMerchant(AMKDLMerchant amkdlMerchant) throws DeeplinkException {
        AMKDLMerchant validAMKDLMerchant = new AMKDLMerchant();
        validAMKDLMerchant.setMerchantId(AMKDLValidation.getMerchantId(amkdlMerchant.getMerchantId()));
        validAMKDLMerchant.setReferenceId(AMKDLValidation.getReferenceId(amkdlMerchant.getReferenceId(), amkdlMerchant.getMerchantId()));
        validAMKDLMerchant.setMerchantName(AMKDLValidation.getMerchantName(amkdlMerchant.getMerchantName()));
        validAMKDLMerchant.setAMKDLCurrency(AMKDLValidation.getCurrencyType(amkdlMerchant.getAMKDLCurrency()));
        validAMKDLMerchant.setAmount(AMKDLValidation.getAmount(amkdlMerchant.getAmount(), amkdlMerchant.getAMKDLCurrency()));
        validAMKDLMerchant.setMobileNumber(AMKDLValidation.getMobileNumber(amkdlMerchant.getMobileNumber()));
        validAMKDLMerchant.setBillNumber(AMKDLValidation.getBillNumber(amkdlMerchant.getBillNumber()));
        validAMKDLMerchant.setStoreLabel(AMKDLValidation.getStoreLabel(amkdlMerchant.getStoreLabel()));
        validAMKDLMerchant.setTerminalLabel(AMKDLValidation.getTerminalLabel(amkdlMerchant.getTerminalLabel()));
        validAMKDLMerchant.setSourceInfo(AMKDLValidation.getSourceInfo(amkdlMerchant.getSourceInfo()));
        return validAMKDLMerchant;
    }

    private static AMKDLResponse<AMKDeeplinkData> responseError(DeeplinkException exception) {
        AMKDLResponse<AMKDeeplinkData> response = new AMKDLResponse<AMKDeeplinkData>();
        AMKDLStatus status = new AMKDLStatus();
        status.setCode(1);
        status.setErrorCode(exception.getErrorCode());
        status.setMessage(exception.getMessage());
        response.setStatus(status);
        return response;
    }
}

