/*
 * Decompiled with CFR 0.152.
 */
package amk.sdk.deeplink.entity.model;

import amk.sdk.deeplink.entity.model.AMKDLCurrency;
import amk.sdk.deeplink.entity.model.Md5Config;
import amk.sdk.deeplink.entity.model.SourceInfo;
import amk.sdk.deeplink.exception.DeeplinkException;
import amk.sdk.deeplink.utils.StringUtils;
import java.math.BigDecimal;
import java.util.regex.Pattern;

public class AMKDLValidation {
    private static boolean isAmountInvalid(Double amount, AMKDLCurrency AMKDLCurrency2) {
        if (amount != null) {
            BigDecimal bd = BigDecimal.valueOf(amount);
            String valueAmount = bd.stripTrailingZeros().toPlainString();
            int index = valueAmount.indexOf(".");
            int decimalCount = index < 0 ? 0 : valueAmount.length() - index - 1;
            int AMOUNT_LENGTH = 13;
            if (amount < 0.0 || valueAmount.length() > AMOUNT_LENGTH) {
                return true;
            }
            if (AMKDLCurrency2 == AMKDLCurrency.USD) {
                return decimalCount >= 3;
            }
            return decimalCount != 0;
        }
        return false;
    }

    public static String getReceiverAccountId(String accountId) throws DeeplinkException {
        int ACCOUNT_ID_LENGTH = 32;
        String FORMAT_ACCOUNT_ID = "^[^@]+[@][^@]+$";
        if (StringUtils.isBlank(accountId)) {
            DeeplinkException.throwCustomerException(1);
        } else if (accountId.length() > ACCOUNT_ID_LENGTH) {
            DeeplinkException.throwCustomerException(3);
        } else if (!Pattern.matches(FORMAT_ACCOUNT_ID, accountId)) {
            DeeplinkException.throwCustomerException(2);
        }
        return accountId;
    }

    public static String getMerchantName(String merchantName) throws DeeplinkException {
        int MERCHANT_NAME_LENGTH = 25;
        if (StringUtils.isBlank(merchantName)) {
            DeeplinkException.throwCustomerException(4);
        } else if (merchantName.length() > MERCHANT_NAME_LENGTH) {
            DeeplinkException.throwCustomerException(5);
        }
        return merchantName;
    }

    public static String getMerchantId(String merchantId) throws DeeplinkException {
        int MERCHANT_ID_LENGTH = 25;
        if (StringUtils.isBlank(merchantId)) {
            DeeplinkException.throwCustomerException(12);
        } else if (merchantId.length() > MERCHANT_ID_LENGTH) {
            DeeplinkException.throwCustomerException(13);
        }
        return merchantId;
    }

    public static AMKDLCurrency getCurrencyType(AMKDLCurrency AMKDLCurrency2) throws DeeplinkException {
        if (AMKDLCurrency2 == null) {
            DeeplinkException.throwCustomerException(6);
        }
        return AMKDLCurrency2;
    }

    public static Double getAmount(Double amount, AMKDLCurrency AMKDLCurrency2) throws DeeplinkException {
        if (AMKDLValidation.isAmountInvalid(amount, AMKDLCurrency2)) {
            DeeplinkException.throwCustomerException(7);
        }
        return amount;
    }

    public static String getMobileNumber(String mobileNumber) throws DeeplinkException {
        int MOBILE_NUMBER_LENGTH = 12;
        if (mobileNumber != null && mobileNumber.length() > MOBILE_NUMBER_LENGTH) {
            DeeplinkException.throwCustomerException(8);
        }
        return mobileNumber;
    }

    public static String getBillNumber(String billNumber) throws DeeplinkException {
        int BILL_NUMBER_LENGTH = 25;
        if (billNumber != null && billNumber.length() > BILL_NUMBER_LENGTH) {
            DeeplinkException.throwCustomerException(9);
        }
        return billNumber;
    }

    public static String getStoreLabel(String storeLabel) throws DeeplinkException {
        int STORE_LABEL_LENGTH = 25;
        if (storeLabel != null && storeLabel.length() > STORE_LABEL_LENGTH) {
            DeeplinkException.throwCustomerException(10);
        }
        return storeLabel;
    }

    public static String getTerminalLabel(String terminalLabel) throws DeeplinkException {
        int TERMINAL_LABEL_LENGTH = 25;
        if (terminalLabel != null && terminalLabel.length() > TERMINAL_LABEL_LENGTH) {
            DeeplinkException.throwCustomerException(11);
        }
        return terminalLabel;
    }

    public static SourceInfo getSourceInfo(SourceInfo SourceInfo2) throws DeeplinkException {
        if (SourceInfo2 != null) {
            String appName = SourceInfo2.getAppName();
            String appDeepLinkCallback = SourceInfo2.getAppDeeplinkCallback();
            String appIconUrl = SourceInfo2.getAppIconUrl();
            if (StringUtils.isBlank(appName) || StringUtils.isBlank(appDeepLinkCallback) || StringUtils.isBlank(appIconUrl)) {
                DeeplinkException.throwCustomerException(14);
            }
        }
        return SourceInfo2;
    }

    public static String getAccountInformation(String accountInformation) throws DeeplinkException {
        int ACCOUNT_INFORMATION_LENGTH = 32;
        if (accountInformation != null && accountInformation.length() > ACCOUNT_INFORMATION_LENGTH) {
            DeeplinkException.throwCustomerException(19);
        }
        return accountInformation;
    }

    public static String getReferenceId(String referenceId, String id) {
        if (StringUtils.isBlank(referenceId)) {
            return Md5Config.getDefaultHash(id);
        }
        return referenceId;
    }

    public static String getAcquiringBankForMerchant(String acquiringBank) throws DeeplinkException {
        int ACQUIRING_BANK_LENGTH = 32;
        if (StringUtils.isBlank(acquiringBank)) {
            DeeplinkException.throwCustomerException(22);
        } else if (acquiringBank.length() > ACQUIRING_BANK_LENGTH) {
            DeeplinkException.throwCustomerException(20);
        }
        return acquiringBank;
    }

    public static String getAcquiringBankForIndividual(String acquiringBank) throws DeeplinkException {
        int ACQUIRING_BANK_LENGTH = 32;
        if (acquiringBank != null && acquiringBank.length() > ACQUIRING_BANK_LENGTH) {
            DeeplinkException.throwCustomerException(20);
        }
        return acquiringBank;
    }

    public static String getMerchantCity(String merchantCity) throws DeeplinkException {
        int MERCHANT_CITY_LENGTH = 15;
        if (merchantCity.length() > MERCHANT_CITY_LENGTH) {
            DeeplinkException.throwCustomerException(21);
        }
        return merchantCity;
    }
}

