/*
 * Decompiled with CFR 0.152.
 */
package amk.sdk.deeplink.presenter;

import amk.sdk.deeplink.entity.response.OAuthTokenResponse;
import amk.sdk.deeplink.presenter.JwtTokenConfigPresenter;
import amk.sdk.deeplink.utils.StringUtils;
import com.google.gson.Gson;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;

class AuthenticationPresenter {
    AuthenticationPresenter() {
    }

    static String getAccessToken(String clientId, String privateKeyPath, String jwtAudience) throws Exception {
        String jwtToken = JwtTokenConfigPresenter.generateJwtToken(clientId, privateKeyPath, jwtAudience);
        String endpoint = "/api/v1/common/oauth/token";
        OkHttpClient client = new OkHttpClient().newBuilder().build();
        MediaType mediaType = MediaType.parse((String)"application/x-www-form-urlencoded");
        RequestBody body = RequestBody.create((MediaType)mediaType, (String)("grant_type=urn:ietf:params:oauth:grant-type:jwt-bearer&assertion=" + jwtToken));
        Request request = new Request.Builder().url("https://uat-api-nginx.amkcambodia.com:8065" + endpoint).method("POST", body).build();
        Response response = client.newCall(request).execute();
        Gson gson = new Gson();
        ResponseBody responseBody = response.body();
        if (response.isSuccessful() & responseBody != null) {
            String json = responseBody.string();
            OAuthTokenResponse oAuthTokenResponse = (OAuthTokenResponse)gson.fromJson(json, OAuthTokenResponse.class);
            if (StringUtils.isBlank(oAuthTokenResponse.getAccess_token())) {
                return null;
            }
            return oAuthTokenResponse.getAccess_token();
        }
        return null;
    }
}

