/*
 * Decompiled with CFR 0.152.
 */
package amk.sdk.deeplink.presenter;

import amk.sdk.deeplink.entity.model.AMKDLIndividual;
import amk.sdk.deeplink.entity.model.AMKDLMerchant;
import amk.sdk.deeplink.entity.model.AMKDLStatus;
import amk.sdk.deeplink.entity.model.AMKDeeplinkData;
import amk.sdk.deeplink.entity.request.IndividualRequest;
import amk.sdk.deeplink.entity.request.MerchantRequest;
import amk.sdk.deeplink.entity.response.AMKDLApiResponse;
import amk.sdk.deeplink.entity.response.AMKDLResponse;
import amk.sdk.deeplink.exception.DeeplinkException;
import amk.sdk.deeplink.presenter.AuthenticationPresenter;
import amk.sdk.deeplink.utils.StringUtils;
import com.google.gson.Gson;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class DeeplinkPresenter {
    private static final String SUCCESS_CODE = "00";
    private static String mClientId;
    private static String mPrivateKeyPath;
    private static String mJwtAudience;
    private static String referenceId;

    public static void preConfig(String clientId, String privateKeyPath, String jwtAudience) {
        mClientId = clientId;
        mPrivateKeyPath = privateKeyPath;
        mJwtAudience = jwtAudience;
    }

    public static AMKDLResponse<AMKDeeplinkData> generateIndividualDeeplink(AMKDLIndividual amkdlIndividual) throws DeeplinkException {
        return DeeplinkPresenter.okHttpClientGenerator(amkdlIndividual);
    }

    public static AMKDLResponse<AMKDeeplinkData> generateMerchantDeeplink(AMKDLMerchant amkdlMerchant) throws DeeplinkException {
        return DeeplinkPresenter.okHttpClientGenerator(amkdlMerchant);
    }

    private static <T> AMKDLResponse<AMKDeeplinkData> okHttpClientGenerator(T request) throws DeeplinkException {
        String endpoint = "/deep-link/generate";
        String accessToken = null;
        try {
            accessToken = AuthenticationPresenter.getAccessToken(mClientId, mPrivateKeyPath, mJwtAudience);
        }
        catch (Exception e) {
            DeeplinkPresenter.handleException(e);
        }
        if (accessToken == null) {
            DeeplinkException.throwCustomerException(18);
        }
        OkHttpClient client = new OkHttpClient().newBuilder().build();
        Gson gson = new Gson();
        String requestBody = request instanceof AMKDLIndividual ? gson.toJson((Object)DeeplinkPresenter.getIndividualRequest((AMKDLIndividual)request)) : gson.toJson((Object)DeeplinkPresenter.getMerchantRequest((AMKDLMerchant)request));
        MediaType mediaType = MediaType.parse((String)"application/json");
        RequestBody body = RequestBody.create((MediaType)mediaType, (String)requestBody);
        Request apiRequest = new Request.Builder().url("https://uat-api-nginx.amkcambodia.com:8065" + endpoint).method("POST", body).addHeader("Authorization", "Bearer " + accessToken).build();
        try {
            Response response = client.newCall(apiRequest).execute();
            return DeeplinkPresenter.convertToResponseBody(response);
        }
        catch (Exception e) {
            if (e instanceof ConnectException || e instanceof SocketTimeoutException || e instanceof UnknownHostException) {
                DeeplinkException.throwCustomerException(15);
            } else {
                DeeplinkException.throwCustomerException(16);
            }
            return null;
        }
    }

    private static void handleException(Exception e) throws DeeplinkException {
        if (e instanceof DeeplinkException) {
            DeeplinkException.throwCustomerException(((DeeplinkException)e).getErrorCode());
        } else {
            DeeplinkException.throwCustomerException(16);
        }
    }

    private static AMKDLResponse<AMKDeeplinkData> convertToResponseBody(Response response) throws Exception {
        Gson gson = new Gson();
        ResponseBody responseBody = response.body();
        if (responseBody != null) {
            String json = responseBody.string();
            AMKDLApiResponse baseResponse = (AMKDLApiResponse)gson.fromJson(json, AMKDLApiResponse.class);
            return DeeplinkPresenter.responseParser(baseResponse);
        }
        return null;
    }

    private static AMKDLResponse<AMKDeeplinkData> responseParser(AMKDLApiResponse response) {
        AMKDLResponse<AMKDeeplinkData> baseResponse;
        switch (response.getResponseCode()) {
            case "00": {
                baseResponse = DeeplinkPresenter.responseMapper(response);
                break;
            }
            default: {
                baseResponse = DeeplinkPresenter.responseMapper(response);
            }
        }
        return baseResponse;
    }

    private static AMKDLResponse<AMKDeeplinkData> responseMapper(AMKDLApiResponse response) {
        AMKDLResponse<AMKDeeplinkData> baseResponse = new AMKDLResponse<AMKDeeplinkData>();
        if (response != null) {
            AMKDLStatus amkdlStatus = new AMKDLStatus();
            amkdlStatus.setCode(0);
            amkdlStatus.setErrorCode(Integer.parseInt(response.getResponseCode()));
            amkdlStatus.setMessage(response.getMessage());
            baseResponse.setStatus(amkdlStatus);
            if (response.getResult() != null && StringUtils.isNoneBlank(response.getResult().getShortLink())) {
                AMKDeeplinkData amkDeeplinkData = new AMKDeeplinkData();
                amkDeeplinkData.setShortLink(response.getResult().getShortLink());
                amkDeeplinkData.setReferenceId(referenceId);
                baseResponse.setData(amkDeeplinkData);
            }
        }
        return baseResponse;
    }

    private static MerchantRequest getMerchantRequest(AMKDLMerchant amkdlMerchant) {
        referenceId = amkdlMerchant.getReferenceId();
        return new MerchantRequest("MERCHANT", "default@amkb", amkdlMerchant.getReferenceId(), amkdlMerchant.getMerchantId(), "AMK Bank", amkdlMerchant.getAMKDLCurrency().toString(), amkdlMerchant.getAmount(), amkdlMerchant.getMerchantName(), amkdlMerchant.getBillNumber(), amkdlMerchant.getMobileNumber(), amkdlMerchant.getStoreLabel(), amkdlMerchant.getTerminalLabel(), amkdlMerchant.getSourceInfo());
    }

    private static IndividualRequest getIndividualRequest(AMKDLIndividual amkdlIndividual) {
        referenceId = amkdlIndividual.getReferenceId();
        return new IndividualRequest("INDIVIDUAL", amkdlIndividual.getAccountId(), amkdlIndividual.getReferenceId(), amkdlIndividual.getAMKDLCurrency().toString(), amkdlIndividual.getAmount(), amkdlIndividual.getMerchantName(), amkdlIndividual.getBillNumber(), amkdlIndividual.getMobileNumber(), amkdlIndividual.getStoreLabel(), amkdlIndividual.getTerminalLabel());
    }
}

