package amk.sdk.deeplink;

import amk.sdk.deeplink.entity.model.*;
import amk.sdk.deeplink.entity.response.AMKDLResponse;
import amk.sdk.deeplink.presenter.AMKResponseCallback;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;

public class Test {

    public static void main(String[] arg) throws IOException {

        String secretKey = new String(Files.readAllBytes(Paths.get("/Users/vandoeurn-nbc/Documents/freelance2/key/private.key")));

        AMKDeeplink.init(
                "e78e80fc-a20a-4d91-a7ff-1e6a0be126c0",
                secretKey,
                "http://apiserver/api/oauth/token");

        AMKDLIndividual amkdlIndividual = new AMKDLIndividual(
                "14497536",
                "12345678",
                AMKDLCurrency.KHR,
                1000.0,
                "Sambo Seth",
                "Phnom Penh",
                "012345678"
        );

        AMKDeeplink.getInstance().generateIndividualDeeplink(amkdlIndividual, new AMKResponseCallback<AMKDeeplinkData>() {
            @Override
            public void onResponse(AMKDLResponse<AMKDeeplinkData> amkdlResponse) {
                System.out.println(amkdlResponse);
            }
        });
    }
}
