/*
 * Decompiled with CFR 0.152.
 */
package amk.sdk.deeplink.entity.response;

import amk.sdk.deeplink.entity.model.AMKDLStatus;
import amk.sdk.deeplink.entity.model.AMKPaymentStatusData;
import amk.sdk.deeplink.entity.response.AMKDLResponse;
import amk.sdk.deeplink.entity.response.ApiPaymentStatusResponse;
import com.google.gson.Gson;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class PaymentStatusResponseMapper {
    private static Gson gson = new Gson();
    private static final String SUCCESS_CODE = "00";

    public static AMKDLResponse<AMKPaymentStatusData> convertToPaymentStatusResponseBody(Response response) throws Exception {
        ResponseBody responseBody = response.body();
        if (responseBody != null) {
            String json = responseBody.string();
            ApiPaymentStatusResponse baseResponse = (ApiPaymentStatusResponse)gson.fromJson(json, ApiPaymentStatusResponse.class);
            return PaymentStatusResponseMapper.paymentStatusResponseParser(baseResponse);
        }
        return null;
    }

    private static AMKDLResponse<AMKPaymentStatusData> paymentStatusResponseParser(ApiPaymentStatusResponse response) {
        AMKDLResponse<AMKPaymentStatusData> baseResponse;
        switch (response.getResponseCode()) {
            case "00": {
                baseResponse = PaymentStatusResponseMapper.paymentStatusResponseMapper(response);
                break;
            }
            default: {
                baseResponse = PaymentStatusResponseMapper.paymentStatusResponseMapper(response);
            }
        }
        return baseResponse;
    }

    private static AMKDLResponse<AMKPaymentStatusData> paymentStatusResponseMapper(ApiPaymentStatusResponse response) {
        AMKDLStatus amkdlStatus = new AMKDLStatus();
        AMKDLResponse<AMKPaymentStatusData> baseResponse = new AMKDLResponse<AMKPaymentStatusData>();
        if (response.getStatus().equals("success")) {
            if (response.getResult() != null) {
                AMKPaymentStatusData amkDeeplinkData = new AMKPaymentStatusData();
                amkDeeplinkData.setMerchantName(response.getResult().getMerchantName());
                amkDeeplinkData.setMerchantId(response.getResult().getMerchantId());
                amkDeeplinkData.setAmount(response.getResult().getAmount());
                amkDeeplinkData.setCurrency(response.getResult().getCurrency());
                baseResponse.setData(amkDeeplinkData);
            }
        } else {
            amkdlStatus.setCode(1);
            amkdlStatus.setErrorCode(99);
        }
        amkdlStatus.setMessage(response.getMessage());
        baseResponse.setStatus(amkdlStatus);
        return baseResponse;
    }
}

