/*
 * Decompiled with CFR 0.152.
 */
package amk.sdk.deeplink.presenter;

import amk.sdk.deeplink.entity.model.AMKDLIndividual;
import amk.sdk.deeplink.entity.model.AMKDLMerchant;
import amk.sdk.deeplink.entity.model.AMKDeeplinkData;
import amk.sdk.deeplink.entity.model.AMKPaymentStatusData;
import amk.sdk.deeplink.entity.model.AMKRequestBody;
import amk.sdk.deeplink.entity.request.IndividualRequest;
import amk.sdk.deeplink.entity.request.MerchantRequest;
import amk.sdk.deeplink.entity.response.AMKDLResponse;
import amk.sdk.deeplink.entity.response.DeeplinkResponseMapper;
import amk.sdk.deeplink.entity.response.PaymentStatusResponseMapper;
import amk.sdk.deeplink.exception.DeeplinkException;
import amk.sdk.deeplink.presenter.AuthenticationPresenter;
import com.google.gson.Gson;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;

public class DeeplinkPresenter {
    private static String mClientId;
    private static String mSecretKey;
    private static String mJwtAudience;
    private static OkHttpClient client;
    private static MediaType mediaType;
    private static Gson gson;

    public static void preConfig(String clientId, String secretKey, String jwtAudience) {
        mClientId = clientId;
        mSecretKey = secretKey;
        mJwtAudience = jwtAudience;
    }

    public static AMKDLResponse<AMKDeeplinkData> generateIndividualDeeplink(AMKDLIndividual amkdlIndividual) throws DeeplinkException {
        return DeeplinkPresenter.okHttpClientGenerator(amkdlIndividual, true);
    }

    public static AMKDLResponse<AMKDeeplinkData> generateMerchantDeeplink(AMKDLMerchant amkdlMerchant) throws DeeplinkException {
        return DeeplinkPresenter.okHttpClientGenerator(amkdlMerchant, false);
    }

    public static AMKDLResponse<AMKPaymentStatusData> checkPaymentStatus(String referenceId) throws DeeplinkException {
        String endpoint = "/deep-link/payment/status";
        String accessToken = DeeplinkPresenter.getAccessToken();
        String requestBody = gson.toJson((Object)AMKRequestBody.getReferenceIdRequest(referenceId));
        RequestBody body = RequestBody.create((MediaType)mediaType, (String)requestBody);
        Request request = new Request.Builder().url("https://uat-api-nginx.amkcambodia.com:8065" + endpoint).method("POST", body).addHeader("Authorization", "Bearer " + accessToken).build();
        try {
            Response response = client.newCall(request).execute();
            return PaymentStatusResponseMapper.convertToPaymentStatusResponseBody(response);
        }
        catch (Exception e) {
            DeeplinkPresenter.exceptionMapper(e);
            return null;
        }
    }

    private static void exceptionMapper(Exception e) throws DeeplinkException {
        if (e instanceof ConnectException || e instanceof SocketTimeoutException || e instanceof UnknownHostException) {
            DeeplinkException.throwCustomerException(21);
        } else {
            DeeplinkException.throwCustomerException(22);
        }
    }

    private static <T> AMKDLResponse<AMKDeeplinkData> okHttpClientGenerator(T request, boolean isIndividual) throws DeeplinkException {
        String requestBody;
        String referenceId;
        String endpoint = isIndividual ? "/deep-link/generate/individual" : "/deep-link/generate/merchant";
        String accessToken = DeeplinkPresenter.getAccessToken();
        if (request instanceof AMKDLIndividual) {
            IndividualRequest individualRequest = AMKRequestBody.getIndividualRequest((AMKDLIndividual)request);
            referenceId = individualRequest.getReferenceId();
            requestBody = gson.toJson((Object)individualRequest);
        } else {
            MerchantRequest merchantRequest = AMKRequestBody.getMerchantRequest((AMKDLMerchant)request);
            referenceId = merchantRequest.getReferenceId();
            requestBody = gson.toJson((Object)merchantRequest);
        }
        RequestBody body = RequestBody.create((MediaType)mediaType, (String)requestBody);
        Request apiRequest = new Request.Builder().url("https://uat-api-nginx.amkcambodia.com:8065" + endpoint).method("POST", body).addHeader("Authorization", "Bearer " + accessToken).build();
        try {
            Response response = client.newCall(apiRequest).execute();
            return DeeplinkResponseMapper.convertToDeeplinkResponseBody(response, referenceId);
        }
        catch (Exception e) {
            DeeplinkPresenter.exceptionMapper(e);
            return null;
        }
    }

    @NotNull
    private static String getAccessToken() throws DeeplinkException {
        String accessToken = null;
        try {
            accessToken = AuthenticationPresenter.getAccessToken(mClientId, mSecretKey, mJwtAudience);
        }
        catch (Exception e) {
            DeeplinkPresenter.exceptionHandler(e);
        }
        if (accessToken == null) {
            DeeplinkException.throwCustomerException(17);
        }
        return accessToken;
    }

    private static void exceptionHandler(Exception e) throws DeeplinkException {
        if (e instanceof DeeplinkException) {
            DeeplinkException.throwCustomerException(((DeeplinkException)e).getErrorCode());
        } else {
            DeeplinkException.throwCustomerException(22);
        }
    }

    static {
        client = new OkHttpClient().newBuilder().build();
        mediaType = MediaType.parse((String)"application/json");
        gson = new Gson();
    }
}

