package amk.sdk.deeplink.utils;


import java.lang.reflect.Array;

public class StringUtils {

    public static final String EMPTY = "";

    public static boolean isBlank(CharSequence cs) {
        int strLen = length(cs);
        if (strLen == 0) {
            return true;
        } else {
            for(int i = 0; i < strLen; ++i) {
                if (!Character.isWhitespace(cs.charAt(i))) {
                    return false;
                }
            }

            return true;
        }
    }

    public static int length(CharSequence cs) {
        return cs == null ? 0 : cs.length();
    }

    public static boolean isNoneBlank(CharSequence... css) {
        return !isAnyBlank(css);
    }
    private static int getLength(Object array) {
        return array == null ? 0 : Array.getLength(array);
    }

    private static boolean isEmpty(Object[] array) {
        return getLength(array) == 0;
    }


    private static boolean isAnyBlank(CharSequence... css) {
        if (isEmpty(css)) {
            return false;
        } else {
            CharSequence[] var1 = css;
            int var2 = css.length;

            for(int var3 = 0; var3 < var2; ++var3) {
                CharSequence cs = var1[var3];
                if (isBlank(cs)) {
                    return true;
                }
            }

            return false;
        }
    }
    public static boolean isNotBlank(CharSequence cs) {
        return !isBlank(cs);
    }


    public static boolean isEmpty(CharSequence cs) {
        return cs == null || cs.length() == 0;
    }
}
