/*
 * Decompiled with CFR 0.152.
 */
package amk.sdk.deeplink;

import amk.sdk.deeplink.entity.model.AMKDLIndividual;
import amk.sdk.deeplink.entity.model.AMKDLMerchant;
import amk.sdk.deeplink.entity.model.AMKDLStatus;
import amk.sdk.deeplink.entity.model.AMKDLValidation;
import amk.sdk.deeplink.entity.model.AMKDeeplinkData;
import amk.sdk.deeplink.entity.model.AMKPaymentStatusData;
import amk.sdk.deeplink.entity.response.AMKDLResponse;
import amk.sdk.deeplink.exception.DeeplinkException;
import amk.sdk.deeplink.presenter.AMKResponseCallback;
import amk.sdk.deeplink.presenter.DeeplinkPresenter;

public class AMKDeeplink {
    private static final int ERROR_CODE = 1;
    private static AMKDeeplink amkDeeplinkInstance = null;

    public static AMKDeeplink getInstance() {
        if (amkDeeplinkInstance == null) {
            amkDeeplinkInstance = new AMKDeeplink();
        }
        return amkDeeplinkInstance;
    }

    private AMKDeeplink() {
    }

    public static void init(String clientId, String secretKey, String jwtAudience) {
        DeeplinkPresenter.preConfig(clientId, secretKey, jwtAudience);
    }

    public void generateIndividualDeeplink(AMKDLIndividual AMKDLIndividual2, AMKResponseCallback<AMKDeeplinkData> responseCallback) {
        new Thread(() -> {
            try {
                responseCallback.onResponse(DeeplinkPresenter.generateIndividualDeeplink(AMKDeeplink.getValidIndividual(AMKDLIndividual2)));
            }
            catch (DeeplinkException exception) {
                responseCallback.onResponse(AMKDeeplink.responseError(exception));
            }
        }).start();
    }

    public void checkPaymentStatus(String referenceId, AMKResponseCallback<AMKPaymentStatusData> responseCallback) {
        new Thread(() -> {
            try {
                responseCallback.onResponse(DeeplinkPresenter.checkPaymentStatus(AMKDLValidation.getValidReferenceId(referenceId)));
            }
            catch (DeeplinkException exception) {
                responseCallback.onResponse(AMKDeeplink.responseError(exception));
            }
        }).start();
    }

    public void generateMerchantDeeplink(AMKDLMerchant amkdlMerchant, AMKResponseCallback<AMKDeeplinkData> responseCallback) {
        new Thread(() -> {
            try {
                responseCallback.onResponse(DeeplinkPresenter.generateMerchantDeeplink(AMKDeeplink.getValidMerchant(amkdlMerchant)));
            }
            catch (DeeplinkException exception) {
                responseCallback.onResponse(AMKDeeplink.responseError(exception));
            }
        }).start();
    }

    private static AMKDLIndividual getValidIndividual(AMKDLIndividual amkdlIndividual) throws DeeplinkException {
        AMKDLIndividual validAMKDLIndividual = new AMKDLIndividual();
        validAMKDLIndividual.setAccountId(AMKDLValidation.getReceiverAccountId(amkdlIndividual.getAccountId()));
        validAMKDLIndividual.setReferenceId(AMKDLValidation.getReferenceId(amkdlIndividual.getReferenceId(), amkdlIndividual.getAccountId()));
        validAMKDLIndividual.setCurrency(AMKDLValidation.getCurrencyType(amkdlIndividual.getCurrency()));
        validAMKDLIndividual.setAmount(AMKDLValidation.getAmount(amkdlIndividual.getAmount(), amkdlIndividual.getCurrency()));
        validAMKDLIndividual.setUsername(AMKDLValidation.getUsername(amkdlIndividual.getUsername()));
        validAMKDLIndividual.setCity(AMKDLValidation.getMerchantCity(amkdlIndividual.getCity()));
        validAMKDLIndividual.setMobileNumber(AMKDLValidation.getMobileNumber(amkdlIndividual.getMobileNumber()));
        return validAMKDLIndividual;
    }

    private static AMKDLMerchant getValidMerchant(AMKDLMerchant amkdlMerchant) throws DeeplinkException {
        AMKDLMerchant validAMKDLMerchant = new AMKDLMerchant();
        validAMKDLMerchant.setReferenceId(AMKDLValidation.getReferenceId(amkdlMerchant.getReferenceId(), amkdlMerchant.getMerchantAccount()));
        validAMKDLMerchant.setMerchantAccount(AMKDLValidation.getMerchantAccount(amkdlMerchant.getMerchantAccount()));
        validAMKDLMerchant.setCurrency(AMKDLValidation.getCurrencyType(amkdlMerchant.getCurrency()));
        validAMKDLMerchant.setAmount(AMKDLValidation.getAmount(amkdlMerchant.getAmount(), amkdlMerchant.getCurrency()));
        validAMKDLMerchant.setMerchantName(AMKDLValidation.getMerchantName(amkdlMerchant.getMerchantName()));
        validAMKDLMerchant.setReceiverName(AMKDLValidation.getReceiverName(amkdlMerchant.getReceiverName()));
        validAMKDLMerchant.setMerchantCity(AMKDLValidation.getMerchantCity(amkdlMerchant.getMerchantCity()));
        validAMKDLMerchant.setBillNumber(AMKDLValidation.getBillNumber(amkdlMerchant.getBillNumber()));
        validAMKDLMerchant.setMobileNumber(AMKDLValidation.getMobileNumber(amkdlMerchant.getMobileNumber()));
        validAMKDLMerchant.setStoreLabel(AMKDLValidation.getStoreLabel(amkdlMerchant.getStoreLabel()));
        validAMKDLMerchant.setTerminalLabel(AMKDLValidation.getTerminalLabel(amkdlMerchant.getTerminalLabel()));
        validAMKDLMerchant.setSourceInfo(AMKDLValidation.getSourceInfo(amkdlMerchant.getSourceInfo()));
        return validAMKDLMerchant;
    }

    private static <T> AMKDLResponse<T> responseError(DeeplinkException exception) {
        AMKDLResponse response = new AMKDLResponse();
        AMKDLStatus status = new AMKDLStatus();
        status.setCode(1);
        status.setErrorCode(exception.getErrorCode());
        status.setMessage(exception.getMessage());
        response.setStatus(status);
        return response;
    }
}

