package amk.sdk.deeplink;

import amk.sdk.deeplink.entity.model.*;
import amk.sdk.deeplink.exception.DeeplinkException;
import amk.sdk.deeplink.entity.response.AMKDLResponse;
import amk.sdk.deeplink.presenter.AMKResponseCallback;
import amk.sdk.deeplink.presenter.DeeplinkPresenter;

import static amk.sdk.deeplink.entity.model.AMKDLValidation.*;

public class AMKDeeplink {

    private final static int ERROR_CODE = 1;

    private static AMKDeeplink amkDeeplinkInstance = null;

    public static AMKDeeplink getInstance() {
        if (amkDeeplinkInstance == null) {
            amkDeeplinkInstance = new AMKDeeplink();
        }
        return amkDeeplinkInstance;
    }

    private AMKDeeplink() {

    }

    public static void init(String clientId, String secretKey, String jwtAudience) {
        DeeplinkPresenter.preConfig(clientId, secretKey, jwtAudience);
    }

    public void generateIndividualDeeplink(AMKDLIndividual AMKDLIndividual, AMKResponseCallback<AMKDeeplinkData> responseCallback) {
        new Thread(() -> {
            try {
                responseCallback.onResponse(DeeplinkPresenter.generateIndividualDeeplink(getValidIndividual(AMKDLIndividual)));
            } catch (DeeplinkException exception) {
                responseCallback.onResponse(responseError(exception));
            }
        }).start();

    }

    public void checkPaymentStatus(String referenceId, AMKResponseCallback<AMKPaymentStatusData> responseCallback) {
        new Thread(() -> {
            try {
                responseCallback.onResponse(DeeplinkPresenter.checkPaymentStatus(getValidReferenceId(referenceId)));
            } catch (DeeplinkException exception) {
                responseCallback.onResponse(responseError(exception));
            }

        }).start();
    }

    public void generateMerchantDeeplink(AMKDLMerchant amkdlMerchant, AMKResponseCallback<AMKDeeplinkData> responseCallback) {
        new Thread(() -> {
            try {
                responseCallback.onResponse(DeeplinkPresenter.generateMerchantDeeplink(getValidMerchant(amkdlMerchant)));
            } catch (DeeplinkException exception) {
                responseCallback.onResponse(responseError(exception));
            }
        }).start();

    }

    private static AMKDLIndividual getValidIndividual(AMKDLIndividual amkdlIndividual) throws DeeplinkException {

        amk.sdk.deeplink.entity.model.AMKDLIndividual validAMKDLIndividual = new AMKDLIndividual();
        validAMKDLIndividual.setAccountId(getReceiverAccountId(amkdlIndividual.getAccountId()));
        validAMKDLIndividual.setReferenceId(getReferenceId(amkdlIndividual.getReferenceId(), amkdlIndividual.getAccountId()));
        validAMKDLIndividual.setCurrency(getCurrencyType(amkdlIndividual.getCurrency()));
        validAMKDLIndividual.setAmount(getAmount(amkdlIndividual.getAmount(), amkdlIndividual.getCurrency()));
        validAMKDLIndividual.setUsername(getUsername(amkdlIndividual.getUsername()));
        validAMKDLIndividual.setCity(getMerchantCity(amkdlIndividual.getCity()));
        validAMKDLIndividual.setMobileNumber(getMobileNumber(amkdlIndividual.getMobileNumber()));
        return validAMKDLIndividual;
    }

    private static AMKDLMerchant getValidMerchant(AMKDLMerchant amkdlMerchant) throws DeeplinkException {
        AMKDLMerchant validAMKDLMerchant = new AMKDLMerchant();
        validAMKDLMerchant.setReferenceId(getReferenceId(amkdlMerchant.getReferenceId(), amkdlMerchant.getMerchantAccount()));
        validAMKDLMerchant.setMerchantAccount(getMerchantAccount(amkdlMerchant.getMerchantAccount()));
        validAMKDLMerchant.setCurrency(getCurrencyType(amkdlMerchant.getCurrency()));
        validAMKDLMerchant.setAmount(getAmount(amkdlMerchant.getAmount(), amkdlMerchant.getCurrency()));
        validAMKDLMerchant.setMerchantName(getMerchantName(amkdlMerchant.getMerchantName()));
        validAMKDLMerchant.setReceiverName(getReceiverName(amkdlMerchant.getReceiverName()));
        validAMKDLMerchant.setMerchantCity(getMerchantCity(amkdlMerchant.getMerchantCity()));
        validAMKDLMerchant.setBillNumber(getBillNumber(amkdlMerchant.getBillNumber()));
        validAMKDLMerchant.setMobileNumber(getMobileNumber(amkdlMerchant.getMobileNumber()));
        validAMKDLMerchant.setStoreLabel(getStoreLabel(amkdlMerchant.getStoreLabel()));
        validAMKDLMerchant.setTerminalLabel(getTerminalLabel(amkdlMerchant.getTerminalLabel()));
        validAMKDLMerchant.setSourceInfo(getSourceInfo(amkdlMerchant.getSourceInfo()));

        return validAMKDLMerchant;
    }

    private static <T> AMKDLResponse<T> responseError(DeeplinkException exception) {
        AMKDLResponse<T> response = new AMKDLResponse<T>();
        AMKDLStatus status = new AMKDLStatus();

        status.setCode(ERROR_CODE);
        status.setErrorCode(exception.getErrorCode());
        status.setMessage(exception.getMessage());
        response.setStatus(status);

        return response;
    }

}
