package amk.sdk.deeplink.entity.response;

import amk.sdk.deeplink.entity.model.AMKDLStatus;
import amk.sdk.deeplink.entity.model.AMKDeeplinkData;
import amk.sdk.deeplink.utils.StringUtils;
import com.google.gson.Gson;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class DeeplinkResponseMapper {

    private static Gson gson = new Gson();
    private static final String SUCCESS_CODE = "00";
    public static AMKDLResponse<AMKDeeplinkData> convertToDeeplinkResponseBody(Response response, String referenceId) throws Exception {

        AMKDLApiResponse baseResponse;
        ResponseBody responseBody = response.body();
        if (responseBody != null) {
            String json = responseBody.string();
            baseResponse = gson.fromJson(
                    json,
                    AMKDLApiResponse.class
            );
            return responseParser(baseResponse, referenceId);
        }
        return null;
    }

    private static AMKDLResponse<AMKDeeplinkData> responseMapper(AMKDLApiResponse response, String referenceId) {
        AMKDLStatus amkdlStatus = new AMKDLStatus();
        AMKDLResponse<AMKDeeplinkData> baseResponse = new AMKDLResponse<>();
        if (response.getStatus().equals("success")) {
            if (response.getResult() != null && StringUtils.isNoneBlank(response.getResult().getShortLink())) {
                AMKDeeplinkData amkDeeplinkData = new AMKDeeplinkData();
                amkDeeplinkData.setShortLink(response.getResult().getShortLink());
                amkDeeplinkData.setReferenceId(referenceId);
                baseResponse.setData(amkDeeplinkData);
            }
        } else {
            amkdlStatus.setCode(1);
            // api error 99
            amkdlStatus.setErrorCode(99);
        }
        amkdlStatus.setMessage(response.getMessage());
        baseResponse.setStatus(amkdlStatus);
        return baseResponse;
    }

    private static AMKDLResponse<AMKDeeplinkData> responseParser(AMKDLApiResponse response, String referenceId) {
        AMKDLResponse<AMKDeeplinkData> baseResponse;
        switch (response.getResponseCode()) {
            case SUCCESS_CODE: {
                baseResponse = responseMapper(response, referenceId);
                break;
            }
            // other cases
            default: {
                baseResponse = responseMapper(response, referenceId);
            }
        }
        return baseResponse;
    }
}
