/*
 * Decompiled with CFR 0.152.
 */
package amk.sdk.deeplink.presenter;

import amk.sdk.deeplink.exception.DeeplinkException;
import amk.sdk.deeplink.utils.StringUtils;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Base64;
import java.util.Date;

public class JwtTokenConfigPresenter {
    private static final long JWT_TOKEN_VALIDITY = 300000L;
    private static final long JWT_TOKEN_OFFSET = 3000L;

    public static String generateJwtToken(String clientId, String secretKey, String jwtAudience) throws Exception {
        if (StringUtils.isBlank(clientId)) {
            DeeplinkException.throwCustomerException(18);
        } else if (StringUtils.isBlank(secretKey)) {
            DeeplinkException.throwCustomerException(20);
        } else if (StringUtils.isBlank(jwtAudience)) {
            DeeplinkException.throwCustomerException(19);
        }
        long nowMillis = System.currentTimeMillis() - 3000L;
        Date now = new Date(nowMillis);
        long expired = nowMillis + 300000L + 3000L;
        Date exp = new Date(expired);
        return Jwts.builder().setIssuer(clientId).setAudience(jwtAudience).setIssuedAt(now).setExpiration(exp).signWith(SignatureAlgorithm.RS256, (Key)JwtTokenConfigPresenter.getRawSecretKey(secretKey)).compact();
    }

    private static PrivateKey getRawSecretKey(String secretKey) throws Exception {
        String replaceSecretKeyString = secretKey.replaceAll(System.lineSeparator(), "").replace("-----BEGIN RSA PRIVATE KEY-----", "").replace("-----END RSA PRIVATE KEY-----", "").replace("-----BEGIN PRIVATE KEY-----", "").replace("-----END PRIVATE KEY-----", "");
        KeyFactory fact = KeyFactory.getInstance("RSA");
        byte[] bytes = Base64.getDecoder().decode(replaceSecretKeyString.getBytes(StandardCharsets.UTF_8));
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(bytes);
        return fact.generatePrivate(keySpec);
    }
}

