/*
 * Decompiled with CFR 0.152.
 */
package amk.sdk.deeplink.presenter;

import amk.sdk.deeplink.presenter.ApiConstant;
import amk.sdk.deeplink.presenter.JwtTokenConfigPresenter;
import amk.sdk.deeplink.utils.StringUtils;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.json.JSONObject;

final class AuthenticationPresenter {
    AuthenticationPresenter() {
    }

    public static String getAccessToken(String clientId, String privateKeyPath, String jwtAudience) throws Exception {
        try {
            String accessToken = AuthenticationPresenter.getAccessToken(ApiConstant.getBaseUrl(), clientId, privateKeyPath, jwtAudience);
            if (StringUtils.isBlank(accessToken)) {
                ApiConstant.switchUrl();
                return AuthenticationPresenter.getAccessToken(ApiConstant.getBaseUrl(), clientId, privateKeyPath, jwtAudience);
            }
            return accessToken;
        }
        catch (Exception e) {
            ApiConstant.switchUrl();
            return AuthenticationPresenter.getAccessToken(ApiConstant.getBaseUrl(), clientId, privateKeyPath, jwtAudience);
        }
    }

    private static String getAccessToken(String baseurl, String clientId, String privateKeyPath, String jwtAudience) throws Exception {
        String jwtToken = JwtTokenConfigPresenter.generateJwtToken(clientId, privateKeyPath, jwtAudience);
        String endpoint = "api/v1/common/oauth/token";
        OkHttpClient client = new OkHttpClient().newBuilder().build();
        MediaType mediaType = MediaType.parse((String)"application/x-www-form-urlencoded");
        RequestBody body = RequestBody.create((String)("grant_type=" + ApiConstant.GRANT_TYPE + "&assertion=" + jwtToken), (MediaType)mediaType);
        Request request = new Request.Builder().url(baseurl + endpoint).method("POST", body).addHeader("Content-Type", "application/x-www-form-urlencoded").build();
        Response response = client.newCall(request).execute();
        ResponseBody responseBody = response.body();
        if (response.isSuccessful() && responseBody != null) {
            String json = responseBody.string();
            return new JSONObject(json).optString("access_token");
        }
        return null;
    }
}

