package amk.sdk.deeplink.entity.model;

import java.util.HashMap;

public class AMKDLErrorCode {

    public static final int ACCOUNT_ID_REQUIRED = 1;
    public static final int ACCOUNT_ID_LENGTH_INVALID = 2;
    public static final int MERCHANT_NAME_REQUIRED = 3;
    public static final int MERCHANT_NAME_LENGTH_INVALID = 4;
    public static final int CURRENCY_TYPE_REQUIRED = 5;
    public static final int AMOUNT_INVALID = 6;
    public static final int CITY_LENGTH_INVALID = 7;
    public static final int USERNAME_REQUIRED = 8;
    public static final int USERNAME_LENGTH_INVALID = 9;
    public static final int MOBILE_NUMBER_LENGTH_INVALID = 10;
    public static final int BILL_NUMBER_LENGTH_INVALID = 11;
    public static final int STORE_LABEL_LENGTH_INVALID = 12;
    public static final int TERMINAL_LABEL_LENGTH_INVALID = 13;
    public static final int MERCHANT_ID_REQUIRED = 14;
    public static final int MERCHANT_ID_LENGTH_INVALID = 15;
    public static final int SOURCE_INFO_INVALID = 16;
    public static final int JWT_CONFIG_IS_INVALID = 17;
    public static final int CLIENT_ID_REQUIRED = 18;
    public static final int JWT_AUDIENCE_REQUIRED = 19;
    public static final int SECRET_KEY_REQUIRED = 20;
    public static final int NO_INTERNET_CONNECTION = 21;
    public static final int SOMETHING_WENT_WRONG = 22;
    public static final int REFERENCE_ID_REQUIRED = 23;

    public static final HashMap<Integer, String> errorCodeMap = new HashMap<Integer, String>() {
        {
            put(ACCOUNT_ID_REQUIRED, "Account ID cannot be null or empty");
            put(ACCOUNT_ID_LENGTH_INVALID, "Account ID Length is invalid");
            put(MERCHANT_NAME_REQUIRED, "Merchant Name cannot be null or empty");
            put(MERCHANT_NAME_LENGTH_INVALID, "Merchant Name Length is invalid");
            put(CURRENCY_TYPE_REQUIRED, "Currency type cannot be null or empty");
            put(AMOUNT_INVALID, "Amount is invalid");
            put(CITY_LENGTH_INVALID, "City Length is invalid");
            put(USERNAME_REQUIRED, "Username cannot be null or empty");
            put(USERNAME_LENGTH_INVALID, "Username Length is invalid");
            put(MOBILE_NUMBER_LENGTH_INVALID, "Mobile Number Length is invalid");
            put(BILL_NUMBER_LENGTH_INVALID, "Bill Number Length is invalid");
            put(STORE_LABEL_LENGTH_INVALID, "Store Label Length is invalid");
            put(TERMINAL_LABEL_LENGTH_INVALID, "Terminal Label Length is invalid");
            put(MERCHANT_ID_REQUIRED, "Merchant ID cannot be null or empty");
            put(MERCHANT_ID_LENGTH_INVALID, "Merchant ID Length is invalid");
            put(SOURCE_INFO_INVALID, "Source Info is invalid");
            put(JWT_CONFIG_IS_INVALID, "Invalid JWT token, or error");
            put(CLIENT_ID_REQUIRED, "Client ID cannot be null or empty");
            put(JWT_AUDIENCE_REQUIRED, "JWT audience cannot be null or empty");
            put(SECRET_KEY_REQUIRED, "Secret Key cannot be null or empty");
            put(NO_INTERNET_CONNECTION, "Please check internet connection");
            put(SOMETHING_WENT_WRONG, "Something went wrong");
            put(REFERENCE_ID_REQUIRED, "ReferenceId cannot be null or empty");
        }
    };
}
