package amk.sdk.deeplink.entity.model;

import org.json.JSONException;
import org.json.JSONObject;

public class SourceInfo {
    private String appIconUrl;
    private String appName;
    private String appDeepLinkCallback;

    public SourceInfo(String appIconUrl, String appName, String appDeepLinkCallback) {
        setAppIconUrl(appIconUrl);
        setAppName(appName);
        setAppDeeplinkCallback(appDeepLinkCallback);
    }

    public SourceInfo() {
    }

    public String getAppIconUrl() {
        return appIconUrl;
    }

    public void setAppIconUrl(String appIconUrl) {
        this.appIconUrl = appIconUrl;
    }

    public String getAppName() {
        return appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getAppDeeplinkCallback() {
        return appDeepLinkCallback;
    }

    public void setAppDeeplinkCallback(String appDeeplinkCallback) {
        this.appDeepLinkCallback = appDeeplinkCallback;
    }

    public JSONObject toJSON() {
        JSONObject jb = new JSONObject();
        try {
            jb.put("appIconUrl", getAppIconUrl());
            jb.put("appName", getAppName());
            jb.put("appDeepLinkCallback", getAppDeeplinkCallback());
        } catch (JSONException ignored) {
        }
        return jb;
    }

    @Override
    public String toString() {
        return toJSON().toString();
    }
}
