package amk.sdk.deeplink.exception;

import amk.sdk.deeplink.entity.model.AMKDLErrorCode;

public class DeeplinkException extends java.lang.Exception {

    private final int errorCode;

    public DeeplinkException(int errorCode) {
        super(AMKDLErrorCode.errorCodeMap.get(errorCode));
        this.errorCode = errorCode;
    }

    public int getErrorCode() {
        return errorCode;
    }

    public static void throwCustomerException(int errorCode) throws DeeplinkException {
        throw new DeeplinkException(errorCode);
    }
}
