package amk.sdk.deeplink.presenter;

import amk.sdk.deeplink.entity.model.AMKDLStatus;
import amk.sdk.deeplink.entity.model.AMKPaymentStatusData;
import amk.sdk.deeplink.entity.response.AMKDLResponse;
import amk.sdk.deeplink.entity.response.ApiPaymentStatusResponse;
import com.google.gson.Gson;
import okhttp3.Response;
import okhttp3.ResponseBody;

final class PaymentStatusResponseMapper {

    private static final Gson gson = new Gson();
    private static final String SUCCESS_CODE = "00";

    public static AMKDLResponse<AMKPaymentStatusData> convertToPaymentStatusResponseBody(Response response) throws Exception {

        ApiPaymentStatusResponse baseResponse;
        ResponseBody responseBody = response.body();
        if (responseBody != null) {
            String json = responseBody.string();
            baseResponse = gson.fromJson(
                    json,
                    ApiPaymentStatusResponse.class
            );
            return paymentStatusResponseParser(baseResponse);
        }
        return null;
    }

    private static AMKDLResponse<AMKPaymentStatusData> paymentStatusResponseParser(ApiPaymentStatusResponse response) {
        AMKDLResponse<AMKPaymentStatusData> baseResponse;
        switch (response.getResponseCode()) {
            case SUCCESS_CODE: {
                baseResponse = paymentStatusResponseMapper(response);
                break;
            }
            // other cases
            default: {
                baseResponse = paymentStatusResponseMapper(response);
            }
        }

        return baseResponse;
    }

    private static AMKDLResponse<AMKPaymentStatusData> paymentStatusResponseMapper(ApiPaymentStatusResponse response) {
        AMKDLStatus amkdlStatus = new AMKDLStatus();
        AMKDLResponse<AMKPaymentStatusData> baseResponse = new AMKDLResponse<>();
        if (response.getStatus().equals("success")) {
            if (response.getResult() != null) {
                AMKPaymentStatusData amkDeeplinkData = new AMKPaymentStatusData();
                amkDeeplinkData.setMerchantName(response.getResult().getMerchantName());
                amkDeeplinkData.setMerchantId(response.getResult().getMerchantId());
                amkDeeplinkData.setAmount(response.getResult().getAmount());
                amkDeeplinkData.setCurrency(response.getResult().getCurrency());
                baseResponse.setData(amkDeeplinkData);
            }
        } else {
            amkdlStatus.setCode(1);
            // api error 99
            amkdlStatus.setErrorCode(99);
        }
        amkdlStatus.setMessage(response.getMessage());
        baseResponse.setStatus(amkdlStatus);
        return baseResponse;
    }

}
