package amk.sdk.deeplink.presenter;

import org.json.JSONException;
import org.json.JSONObject;


public class AMKDLIndividual extends AMKRequestBody {
    private String receiveAccountId;
    private String currency;
    private String amount;
    private String accountName;
    private String city = "Phnom Penh";
    private String mobileNumber;

    public AMKDLIndividual() {
    }

    public AMKDLIndividual(String receiveAccountId, String currency, String amount, String accountName) {
        setReceiveAccountId(receiveAccountId);
        setCurrency(currency);
        setAmount(amount);
        setAccountName(accountName);
    }

    public String getReceiveAccountId() {
        return receiveAccountId;
    }

    public void setReceiveAccountId(String receiveAccountId) {
        this.receiveAccountId = receiveAccountId;
    }

    public String getCurrency() {
        return currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public String getAmount() {
        return amount;
    }

    public void setAmount(String amount) {
        this.amount = amount;
    }

    public String getAccountName() {
        return accountName;
    }

    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }

    public String getCity() {
        return city;
    }

    public void setCity(String city) {
        this.city = city;
    }


    public String getMobileNumber() {
        return mobileNumber;
    }

    public void setMobileNumber(String mobileNumber) {
        this.mobileNumber = mobileNumber;
    }

    @Override
    public final String getRequestEndpoint() {
        return "deep-link/generate/individual";
    }

    @Override
    public final String toString() {
        JSONObject jb = new JSONObject();
        try {
            jb.put("receiveAccountId", getReceiveAccountId());
            jb.put("referenceId", getReferenceId());
            jb.put("currency", getCurrency());
            jb.put("amount", getAmount());
            jb.put("mobileNumber", getMobileNumber());
            jb.put("merchantCity", getCity());
            jb.put("merchantName", getAccountName());
        } catch (JSONException ignored) {
        }
        return jb.toString();
    }
}
