package amk.sdk.deeplink.presenter;


import amk.sdk.deeplink.utils.StringUtils;
import okhttp3.*;
import org.json.JSONObject;

import java.util.concurrent.TimeUnit;


final class AuthenticationPresenter {

    public static String getAccessToken(String clientId, String privateKeyPath, String jwtAudience) throws Exception {
        try {
            String accessToken = getAccessToken(ApiConstant.getBaseUrl(), clientId, privateKeyPath, jwtAudience);
            if (StringUtils.isBlank(accessToken)) {
                ApiConstant.switchUrl();
                return getAccessToken(ApiConstant.getBaseUrl(), clientId, privateKeyPath, jwtAudience);
            } else {
                return accessToken;
            }
        } catch (Exception e){
            ApiConstant.switchUrl();
            return getAccessToken(ApiConstant.getBaseUrl(), clientId, privateKeyPath, jwtAudience);
        }
    }

    private static String getAccessToken(String baseurl, String clientId, String privateKeyPath, String jwtAudience) throws Exception {
        String jwtToken = JwtTokenConfigPresenter.generateJwtToken(clientId, privateKeyPath, jwtAudience);
        String endpoint = "api/v1/common/oauth/token";
        OkHttpClient client = new OkHttpClient().newBuilder().build();
        MediaType mediaType = MediaType.parse("application/x-www-form-urlencoded");
        RequestBody body = RequestBody.create("grant_type=" + ApiConstant.GRANT_TYPE + "&assertion=" + jwtToken, mediaType);
        Request request = new Request.Builder()
                .url(baseurl + endpoint)
                .method("POST", body)
                .addHeader("Content-Type", "application/x-www-form-urlencoded")
                .build();
        Response response = client.newCall(request).execute();
        ResponseBody responseBody = response.body();
        if (response.isSuccessful() && responseBody != null) {
            String json = responseBody.string();
            return new JSONObject(json).optString("access_token");
        }
        return null;
    }
}
