/*
 * Decompiled with CFR 0.152.
 */
package amk.sdk.deeplink;

import amk.sdk.deeplink.entity.model.AMKDLStatus;
import amk.sdk.deeplink.entity.model.AMKDeeplinkData;
import amk.sdk.deeplink.entity.model.AMKPaymentStatusData;
import amk.sdk.deeplink.entity.response.AMKDLResponse;
import amk.sdk.deeplink.exception.DeeplinkException;
import amk.sdk.deeplink.presenter.AMKDLIndividual;
import amk.sdk.deeplink.presenter.AMKDLMerchant;
import amk.sdk.deeplink.presenter.AMKResponseCallback;
import amk.sdk.deeplink.presenter.DeeplinkPresenter;

public final class AMKDeeplink {
    private static final int ERROR_CODE = 1;
    private static AMKDeeplink amkDeeplinkInstance = null;

    public static AMKDeeplink getInstance() {
        if (amkDeeplinkInstance == null) {
            amkDeeplinkInstance = new AMKDeeplink();
        }
        return amkDeeplinkInstance;
    }

    private AMKDeeplink() {
    }

    public static void init(String clientId, String secretKey) {
        DeeplinkPresenter.preConfig(clientId, secretKey);
    }

    public static void init(String clientId, String secretKey, String jwtAudience) {
        DeeplinkPresenter.preConfig(clientId, secretKey, jwtAudience);
    }

    public static String generateJwt(String clientId, String secretKey, String jwtAudience) {
        return DeeplinkPresenter.generateJwt(clientId, secretKey, jwtAudience);
    }

    public void generateIndividualDeeplink(AMKDLIndividual AMKDLIndividual2, AMKResponseCallback<AMKDeeplinkData> responseCallback) {
        new Thread(() -> {
            try {
                responseCallback.onResponse(DeeplinkPresenter.generateIndividualDeeplink(AMKDLIndividual2));
            }
            catch (DeeplinkException exception) {
                responseCallback.onResponse(AMKDeeplink.responseError(exception));
            }
        }).start();
    }

    public void checkPaymentStatus(String referenceId, AMKResponseCallback<AMKPaymentStatusData> responseCallback) {
        new Thread(() -> {
            try {
                responseCallback.onResponse(DeeplinkPresenter.checkPaymentStatus(referenceId));
            }
            catch (DeeplinkException exception) {
                responseCallback.onResponse(AMKDeeplink.responseError(exception));
            }
        }).start();
    }

    public void generateMerchantDeeplink(AMKDLMerchant amkdlMerchant, AMKResponseCallback<AMKDeeplinkData> responseCallback) {
        new Thread(() -> {
            try {
                responseCallback.onResponse(DeeplinkPresenter.generateMerchantDeeplink(amkdlMerchant));
            }
            catch (DeeplinkException exception) {
                responseCallback.onResponse(AMKDeeplink.responseError(exception));
            }
        }).start();
    }

    private static <T> AMKDLResponse<T> responseError(DeeplinkException exception) {
        AMKDLResponse response = new AMKDLResponse();
        AMKDLStatus status = new AMKDLStatus();
        status.setCode(1);
        status.setErrorCode(exception.getErrorCode());
        status.setMessage(exception.getMessage());
        response.setStatus(status);
        return response;
    }
}

