/*
 * Decompiled with CFR 0.152.
 */
package amk.sdk.deeplink.presenter;

import amk.sdk.deeplink.entity.model.AMKDLExstraData;
import amk.sdk.deeplink.entity.model.SourceInfo;
import amk.sdk.deeplink.presenter.AMKRequestBody;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.json.JSONObject;

public class AMKDLMerchant
extends AMKRequestBody {
    private String merchantAccount;
    private String currency;
    private String amount;
    private String merchantName;
    private String receiverName;
    private String merchantCity = "Phnom Penh";
    private String billNumber = "";
    private String mobileNumber;
    private String storeLabel;
    private String terminalLabel;
    private String channel = "partner";
    private int numberOfPay;
    private String expireDate;
    private AMKDLExstraData data;
    private SourceInfo sourceInfo;

    public AMKDLMerchant(String merchantAccount, String currency, String amount, String merchantName, SourceInfo sourceInfo) {
        this.setMerchantAccount(merchantAccount);
        this.setCurrency(currency);
        this.setAmount(amount);
        this.setMerchantName(merchantName);
        this.setSourceInfo(sourceInfo);
    }

    public String getChannel() {
        return this.channel;
    }

    public void setChannel(String channel) {
        this.channel = channel;
    }

    public String getMerchantAccount() {
        return this.merchantAccount;
    }

    public void setMerchantAccount(String merchantId) {
        this.merchantAccount = merchantId;
    }

    @Override
    public final String getRequestEndpoint() {
        return "deep-link/generate/merchant";
    }

    @Override
    public final String toString() {
        JSONObject jb = new JSONObject();
        try {
            jb.put("merchantAccount", (Object)this.getMerchantAccount());
            jb.put("referenceId", (Object)this.getReferenceId());
            jb.put("currency", (Object)this.getCurrency());
            jb.put("amount", (Object)this.getAmount());
            jb.put("merchantName", (Object)this.getMerchantName());
            jb.put("channel", (Object)this.getChannel());
            jb.put("numberOfPay", this.getNumberOfPay());
            jb.put("expireDate", (Object)this.getExpireDate());
            jb.put("receiverName", (Object)this.getReceiverName());
            jb.put("merchantCity", (Object)this.getMerchantCity());
            jb.put("billNumber", (Object)this.getBillNumber());
            jb.put("mobileNumber", (Object)this.getMobileNumber());
            jb.put("storeLabel", (Object)this.getStoreLabel());
            jb.put("terminalLabel", (Object)this.getTerminalLabel());
            jb.put("sourceInfo", (Object)this.getSourceInfo().toJSON());
            jb.put("data", (Object)this.getData().toJSON());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return jb.toString();
    }

    public int getNumberOfPay() {
        return this.numberOfPay;
    }

    public void setNumberOfPay(int numberOfPay) {
        this.numberOfPay = numberOfPay;
    }

    public String getExpireDate() {
        return this.expireDate;
    }

    public void setExpireDate(Date expireDate) {
        this.expireDate = new SimpleDateFormat("yyyy-MM-dd").format(expireDate);
    }

    public AMKDLExstraData getData() {
        return this.data;
    }

    public void setData(AMKDLExstraData data) {
        this.data = data;
    }

    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public String getAmount() {
        return this.amount;
    }

    public void setAmount(String amount) {
        this.amount = amount;
    }

    public String getMerchantName() {
        return this.merchantName;
    }

    public void setMerchantName(String merchantName) {
        this.merchantName = merchantName;
    }

    public String getReceiverName() {
        return this.receiverName;
    }

    public void setReceiverName(String receiverName) {
        this.receiverName = receiverName;
    }

    public String getMerchantCity() {
        return this.merchantCity;
    }

    public void setMerchantCity(String merchantCity) {
        this.merchantCity = merchantCity;
    }

    public String getBillNumber() {
        return this.billNumber;
    }

    public void setBillNumber(String billNumber) {
        this.billNumber = billNumber;
    }

    public String getMobileNumber() {
        return this.mobileNumber;
    }

    public void setMobileNumber(String mobileNumber) {
        this.mobileNumber = mobileNumber;
    }

    public String getStoreLabel() {
        return this.storeLabel;
    }

    public void setStoreLabel(String storeLabel) {
        this.storeLabel = storeLabel;
    }

    public String getTerminalLabel() {
        return this.terminalLabel;
    }

    public void setTerminalLabel(String terminalLabel) {
        this.terminalLabel = terminalLabel;
    }

    public SourceInfo getSourceInfo() {
        return this.sourceInfo;
    }

    public void setSourceInfo(SourceInfo sourceInfo) {
        this.sourceInfo = sourceInfo;
    }
}

