package amk.sdk.deeplink.presenter;

import org.json.JSONException;
import org.json.JSONObject;


public class AMKDLIndividual extends AMKRequestBody {
    private String receiveAccountId;
    private String currency;
    private String amount;
    private String accountName;
    private String city = "Phnom Penh";
    private String mobileNumber;
    private String appEnv;

    public AMKDLIndividual() {
    }

    public AMKDLIndividual(String receiveAccountId, String currency, String amount, String accountName, String appEnv) {
        setReceiveAccountId(receiveAccountId);
        setCurrency(currency);
        setAmount(amount);
        setAccountName(accountName);
        setAppEnv(appEnv);
    }

    public String getReceiveAccountId() {
        return receiveAccountId;
    }

    public void setReceiveAccountId(String receiveAccountId) {
        this.receiveAccountId = receiveAccountId;
    }

    public String getCurrency() {
        return currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public String getAmount() {
        return amount;
    }

    public void setAmount(String amount) {
        this.amount = amount;
    }

    public String getAccountName() {
        return accountName;
    }

    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }

    public String getCity() {
        return city;
    }

    public void setCity(String city) {
        this.city = city;
    }


    public String getMobileNumber() {
        return mobileNumber;
    }

    public void setMobileNumber(String mobileNumber) {
        this.mobileNumber = mobileNumber;
    }

    public String getAppEnv() {
        return appEnv;
    }

    public void setAppEnv(String appEnv) {
        this.appEnv = appEnv;
    }

    @Override
    public final String getRequestEndpoint() {
        return "deep-link/generate/individual";
    }

    @Override
    public final String toString() {
        JSONObject jb = new JSONObject();
        try {
            jb.put("receiveAccountId", getReceiveAccountId());
            jb.put("referenceId", getReferenceId());
            jb.put("currency", getCurrency());
            jb.put("amount", getAmount());
            jb.put("mobileNumber", getMobileNumber());
            jb.put("merchantCity", getCity());
            jb.put("merchantName", getAccountName());
            jb.put("appEnv", getAppEnv());
        } catch (JSONException ignored) {
        }
        return jb.toString();
    }
}
