package amk.sdk.deeplink.presenter;

import amk.sdk.deeplink.entity.model.AMKDLExstraData;
import amk.sdk.deeplink.entity.model.SourceInfo;
import org.json.JSONObject;

import java.text.SimpleDateFormat;
import java.util.Date;


public class AMKDLMerchant extends AMKRequestBody {
    private String merchantAccount;
    private String currency;
    private String amount;
    private String merchantName;
    private String receiverName;
    private String merchantCity = "Phnom Penh";
    private String billNumber = "";
    private String mobileNumber;
    private String storeLabel;
    private String terminalLabel;
    private String channel="partner";
    private int numberOfPay;
    private String expireDate;
    private AMKDLExstraData data;
    private SourceInfo sourceInfo;

    public AMKDLMerchant(String merchantAccount, String currency, String amount, String merchantName, SourceInfo sourceInfo) {
        setMerchantAccount(merchantAccount);
        setCurrency(currency);
        setAmount(amount);
        setMerchantName(merchantName);
        setSourceInfo(sourceInfo);
    }

    public String getChannel() {
        return channel;
    }

    public void setChannel(String channel) {
        this.channel = channel;
    }

    public String getMerchantAccount() {
        return merchantAccount;
    }

    public void setMerchantAccount(String merchantId) {
        this.merchantAccount = merchantId;
    }

    @Override
    public final String getRequestEndpoint() {
        return "deep-link/generate/merchant";
    }

    @Override
    public final String toString() {
        JSONObject jb = new JSONObject();
        try {
            jb.put("merchantAccount", getMerchantAccount());
            jb.put("referenceId", getReferenceId());
            jb.put("currency", getCurrency());
            jb.put("amount", getAmount());
            jb.put("merchantName", getMerchantName());
            jb.put("channel", getChannel());
            jb.put("numberOfPay", getNumberOfPay());
            jb.put("expireDate", getExpireDate());

            jb.put("receiverName", getReceiverName());
            jb.put("merchantCity", getMerchantCity());
            jb.put("billNumber", getBillNumber());
            jb.put("mobileNumber", getMobileNumber());
            jb.put("storeLabel", getStoreLabel());
            jb.put("terminalLabel", getTerminalLabel());
            jb.put("sourceInfo", getSourceInfo().toJSON());
            jb.put("data", getData().toJSON());
        } catch (Exception ignored) {
        }
        return jb.toString();
    }

    public int getNumberOfPay() {
        return numberOfPay;
    }

    public void setNumberOfPay(int numberOfPay) {
        this.numberOfPay = numberOfPay;
    }

    public String getExpireDate() {
        return expireDate;
    }

    public void setExpireDate(Date expireDate) {
        this.expireDate = new SimpleDateFormat("yyyy-MM-dd").format(expireDate);
    }

    public AMKDLExstraData getData() {
        return data;
    }

    public void setData(AMKDLExstraData data) {
        this.data = data;
    }

    public String getCurrency() {
        return currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public String getAmount() {
        return amount;
    }

    public void setAmount(String amount) {
        this.amount = amount;
    }

    public String getMerchantName() {
        return merchantName;
    }

    public void setMerchantName(String merchantName) {
        this.merchantName = merchantName;
    }

    public String getReceiverName() {
        return receiverName;
    }

    public void setReceiverName(String receiverName) {
        this.receiverName = receiverName;
    }

    public String getMerchantCity() {
        return merchantCity;
    }

    public void setMerchantCity(String merchantCity) {
        this.merchantCity = merchantCity;
    }

    public String getBillNumber() {
        return billNumber;
    }

    public void setBillNumber(String billNumber) {
        this.billNumber = billNumber;
    }

    public String getMobileNumber() {
        return mobileNumber;
    }

    public void setMobileNumber(String mobileNumber) {
        this.mobileNumber = mobileNumber;
    }

    public String getStoreLabel() {
        return storeLabel;
    }

    public void setStoreLabel(String storeLabel) {
        this.storeLabel = storeLabel;
    }

    public String getTerminalLabel() {
        return terminalLabel;
    }

    public void setTerminalLabel(String terminalLabel) {
        this.terminalLabel = terminalLabel;
    }

    public SourceInfo getSourceInfo() {
        return sourceInfo;
    }

    public void setSourceInfo(SourceInfo sourceInfo) {
        this.sourceInfo = sourceInfo;
    }

}
