package amk.sdk.deeplink.presenter;
import java.util.Objects;


final class ApiConstant {
    private static ApiConstant INSTANCE;
    private String BASE_URL_PRO;
    private String BASE_URL_UAT;
    private String BASE_URL;
    public static String GRANT_TYPE;

    private ApiConstant() {
        BASE_URL_PRO = "https://apingx.amkcambodia.com:8065/";
        BASE_URL = BASE_URL_PRO;
        BASE_URL_UAT = "https://uat-api-nginx.amkcambodia.com:8065/";
        GRANT_TYPE = "urn:ietf:params:oauth:grant-type:jwt-bearer";
    }

    public static ApiConstant getInstance() {
        if (INSTANCE == null)
            INSTANCE = new ApiConstant();
        return INSTANCE;
    }

    public static String getBaseUrl() {
        return getInstance().BASE_URL;
    }

    public static void reset() {
        getInstance().BASE_URL = getInstance().BASE_URL_PRO;
    }

    public static void switchUrl() {
        if (Objects.equals(getInstance().BASE_URL, getInstance().BASE_URL_PRO))
            getInstance().BASE_URL = getInstance().BASE_URL_UAT;
        else
            getInstance().BASE_URL = getInstance().BASE_URL_PRO;
    }
}
