/*
 * Decompiled with CFR 0.152.
 */
package amk.sdk.deeplink.presenter;

import amk.sdk.deeplink.entity.model.AMKDeeplinkData;
import amk.sdk.deeplink.entity.model.AMKPaymentStatusData;
import amk.sdk.deeplink.entity.response.AMKDLResponse;
import amk.sdk.deeplink.exception.DeeplinkException;
import amk.sdk.deeplink.presenter.AMKDLIndividual;
import amk.sdk.deeplink.presenter.AMKDLMerchant;
import amk.sdk.deeplink.presenter.AMKRequestBody;
import amk.sdk.deeplink.presenter.ApiConstant;
import amk.sdk.deeplink.presenter.AuthenticationPresenter;
import amk.sdk.deeplink.presenter.DeeplinkResponseMapper;
import amk.sdk.deeplink.presenter.JwtTokenConfigPresenter;
import amk.sdk.deeplink.presenter.PaymentStatusResponseMapper;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import org.json.JSONException;
import org.json.JSONObject;

public final class DeeplinkPresenter {
    private static String mClientId;
    private static String mSecretKey;
    private static String mJwtAudience;
    private static final OkHttpClient client;
    private static final MediaType mediaType;

    public static void preConfig(String clientId, String secretKey, String jwtAudience) {
        mClientId = clientId;
        mSecretKey = secretKey;
        mJwtAudience = jwtAudience;
        ApiConstant.reset();
    }

    public static void preConfig(String baseUrl) {
        if (baseUrl.equals(ApiConstant.getBaseUrl())) {
            ApiConstant.reset();
        } else {
            ApiConstant.switchUrl();
        }
    }

    public static void preConfig(String clientId, String secretKey) {
        DeeplinkPresenter.preConfig(clientId, secretKey, "http://apiserver/api/oauth/token");
    }

    public static String generateJwt(String clientId, String secretKey, String jwtAudience) {
        try {
            return JwtTokenConfigPresenter.generateJwtToken(clientId, secretKey, jwtAudience);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static AMKDLResponse<AMKDeeplinkData> generateIndividualDeeplink(AMKDLIndividual amkdlIndividual) throws DeeplinkException {
        return DeeplinkPresenter.okHttpClientGenerator(amkdlIndividual);
    }

    public static AMKDLResponse<AMKDeeplinkData> generateIndividualDeeplinkV2(AMKDLIndividual amkdlIndividual, String accessToken) throws DeeplinkException {
        return DeeplinkPresenter.okHttpClientGeneratorV2(amkdlIndividual, accessToken);
    }

    public static AMKDLResponse<AMKDeeplinkData> generateMerchantDeeplink(AMKDLMerchant amkdlMerchant) throws DeeplinkException {
        return DeeplinkPresenter.okHttpClientGenerator(amkdlMerchant);
    }

    public static AMKDLResponse<AMKPaymentStatusData> checkPaymentStatus(String referenceId) throws DeeplinkException {
        String endpoint = "deep-link/payment/status";
        String accessToken = DeeplinkPresenter.getAccessToken();
        JSONObject bodyRequest = new JSONObject();
        try {
            bodyRequest.put("referenceId", (Object)referenceId);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        String requestBody = bodyRequest.toString();
        RequestBody body = RequestBody.create((String)requestBody, (MediaType)mediaType);
        Request request = new Request.Builder().url(ApiConstant.getBaseUrl() + endpoint).method("POST", body).addHeader("Authorization", "Bearer " + accessToken).build();
        try {
            Response response = client.newCall(request).execute();
            return PaymentStatusResponseMapper.convertToPaymentStatusResponseBody(response);
        }
        catch (Exception e) {
            DeeplinkPresenter.exceptionMapper(e);
            return null;
        }
    }

    private static void exceptionMapper(Exception e) throws DeeplinkException {
        if (e instanceof ConnectException || e instanceof SocketTimeoutException || e instanceof UnknownHostException) {
            DeeplinkException.throwCustomerException(21);
        } else {
            DeeplinkException.throwCustomerException(22);
        }
    }

    private static <T> AMKDLResponse<AMKDeeplinkData> okHttpClientGenerator(AMKRequestBody request) throws DeeplinkException {
        String endpoint = request.getRequestEndpoint();
        String accessToken = DeeplinkPresenter.getAccessToken();
        String requestBody = request.toString();
        String referenceId = request.getReferenceId();
        RequestBody body = RequestBody.create((String)requestBody, (MediaType)mediaType);
        Request apiRequest = new Request.Builder().url(ApiConstant.getBaseUrl() + endpoint).method("POST", body).addHeader("Authorization", "Bearer " + accessToken).build();
        try {
            Response response = client.newCall(apiRequest).execute();
            return DeeplinkResponseMapper.convertToDeeplinkResponseBody(response, referenceId);
        }
        catch (Exception e) {
            DeeplinkPresenter.exceptionMapper(e);
            return null;
        }
    }

    private static <T> AMKDLResponse<AMKDeeplinkData> okHttpClientGeneratorV2(AMKRequestBody request, String accessToken) throws DeeplinkException {
        String endpoint = request.getRequestEndpoint();
        String requestBody = request.toString();
        String referenceId = request.getReferenceId();
        RequestBody body = RequestBody.create((String)requestBody, (MediaType)mediaType);
        Request apiRequest = new Request.Builder().url(ApiConstant.getBaseUrl() + endpoint).method("POST", body).addHeader("Authorization", "Bearer " + accessToken).build();
        try {
            Response response = client.newCall(apiRequest).execute();
            return DeeplinkResponseMapper.convertToDeeplinkResponseBody(response, referenceId);
        }
        catch (Exception e) {
            DeeplinkPresenter.exceptionMapper(e);
            return null;
        }
    }

    @NotNull
    private static String getAccessToken() throws DeeplinkException {
        String accessToken = null;
        try {
            accessToken = AuthenticationPresenter.getAccessToken(mClientId, mSecretKey, mJwtAudience);
        }
        catch (Exception e) {
            DeeplinkPresenter.exceptionHandler(e);
        }
        if (accessToken == null) {
            DeeplinkException.throwCustomerException(17);
        }
        return accessToken;
    }

    private static void exceptionHandler(Exception e) throws DeeplinkException {
        if (e instanceof DeeplinkException) {
            DeeplinkException.throwCustomerException(((DeeplinkException)e).getErrorCode());
        } else {
            DeeplinkException.throwCustomerException(22);
        }
    }

    static {
        mJwtAudience = "http://apiserver/api/oauth/token";
        client = new OkHttpClient().newBuilder().build();
        mediaType = MediaType.parse((String)"application/json");
    }
}

