/*
 * Decompiled with CFR 0.152.
 */
package sk.antons.sbutils.rest;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;
import sk.antons.jaul.binary.Base64;

public class RestTemplateClient {
    private static Logger log = LoggerFactory.getLogger(RestTemplateClient.class);
    protected String root;
    protected RestTemplate template = null;
    protected BiFunction<String, Object, HttpHeaders> headers = null;
    protected Predicate<ResponseEntity> responseValidator = null;
    public static int counter = 1;

    private RestTemplateClient() {
    }

    protected BiFunction<String, Object, HttpHeaders> headers() {
        if (this.headers == null) {
            this.headers = Headers.contentTypeOnly(MediaType.APPLICATION_JSON);
        }
        return this.headers;
    }

    protected Predicate<ResponseEntity> responseValidator() {
        if (this.responseValidator == null) {
            this.responseValidator = ResponseValidator.successful();
        }
        return this.responseValidator;
    }

    public Request get() {
        return this.request(HttpMethod.GET);
    }

    public Request post() {
        return this.request(HttpMethod.POST);
    }

    public Request delete() {
        return this.request(HttpMethod.DELETE);
    }

    public Request head() {
        return this.request(HttpMethod.HEAD);
    }

    public Request put() {
        return this.request(HttpMethod.PUT);
    }

    private Request request(HttpMethod method) {
        Request r = new Request();
        r.method(method);
        return r;
    }

    public static class Headers {
        private HttpHeaders headers = new HttpHeaders();

        public static BiFunction<String, Object, HttpHeaders> contentTypeOnly(MediaType contentType) {
            return (path, content) -> {
                HttpHeaders headers = new HttpHeaders();
                headers.setContentType(contentType);
                return headers;
            };
        }

        public static BiFunction<String, Object, HttpHeaders> simple(Map<String, String> map) {
            return (path, content) -> {
                HttpHeaders headers = new HttpHeaders();
                for (Map.Entry entry : map.entrySet()) {
                    headers.set((String)entry.getKey(), (String)entry.getValue());
                }
                return headers;
            };
        }

        public static Headers builder() {
            Headers h = new Headers();
            h.headers = new HttpHeaders();
            return h;
        }

        public BiFunction<String, Object, HttpHeaders> build() {
            return (path, content) -> this.headers;
        }

        public Headers contentType(MediaType value) {
            this.headers.setContentType(value);
            return this;
        }

        public Headers accept(MediaType ... value) {
            this.headers.setAccept(Arrays.asList(value));
            return this;
        }

        public Headers setAll(Map<String, String> value) {
            this.headers.setAll(value);
            return this;
        }

        public Headers add(String key, String ... value) {
            this.headers.addAll(key, Arrays.asList(value));
            return this;
        }

        public Headers basicAuth(String user, String password) {
            this.add("Authorization", "Basic " + Base64.standard().encode((user + ":" + password).getBytes()));
            return this;
        }
    }

    public static class ResponseValidator {
        public static Predicate<ResponseEntity> successful() {
            return response -> {
                if (response == null) {
                    return false;
                }
                if (response.getStatusCode() == null) {
                    return false;
                }
                return response.getStatusCode().is2xxSuccessful();
            };
        }

        public static Predicate<ResponseEntity> listedCodes(int ... codes) {
            return response -> {
                if (codes == null) {
                    return false;
                }
                if (response == null) {
                    return false;
                }
                if (response.getStatusCode() == null) {
                    return false;
                }
                for (int code : codes) {
                    if (response.getStatusCodeValue() != code) continue;
                    return true;
                }
                return false;
            };
        }
    }

    public class Request {
        private HttpMethod method;
        private String path;
        private Object content;
        private HttpHeaders headers;

        private Request() {
        }

        private Request method(HttpMethod value) {
            this.method = value;
            return this;
        }

        public Request path(String value) {
            this.path = value;
            return this;
        }

        public Request content(Object value) {
            this.content = value;
            return this;
        }

        public Request headers(HttpHeaders value) {
            this.headers = value;
            return this;
        }

        public void call() {
            this.call(String.class, null);
        }

        public <T> T call(Class<T> clazz) {
            return this.call(clazz, null);
        }

        public <T> T call(ParameterizedTypeReference<T> type) {
            return this.call(null, type);
        }

        private <T> T call(Class<T> clazz, ParameterizedTypeReference<T> type) {
            int id = counter++;
            if (log.isDebugEnabled()) {
                log.debug("req[{}] {} {}", new Object[]{id, this.method.name(), this.url()});
            }
            long starttime = System.currentTimeMillis();
            long requesttime = 0L;
            try {
                UriComponentsBuilder builder = UriComponentsBuilder.fromHttpUrl((String)this.url());
                HttpEntity entity = new HttpEntity(this.content, (MultiValueMap)(this.headers == null ? (MultiValueMap)RestTemplateClient.this.headers().apply(this.path, this.content) : this.headers));
                ResponseEntity response = null;
                response = clazz != null ? RestTemplateClient.this.template.exchange(builder.build().toUriString(), this.method, entity, clazz, new Object[0]) : RestTemplateClient.this.template.exchange(builder.build().toUriString(), this.method, entity, type, new Object[0]);
                requesttime = System.currentTimeMillis() - starttime;
                if (log.isDebugEnabled()) {
                    log.debug("res[{}] {} {} status: {}, time: {}", new Object[]{id, this.method.name(), this.url(), response.getStatusCodeValue(), requesttime});
                }
                if (RestTemplateClient.this.responseValidator().test(response)) {
                    return (T)response.getBody();
                }
                throw new HttpException(response).method(this.method).url(this.url());
            }
            catch (Throwable e) {
                if (log.isDebugEnabled()) {
                    log.debug("res[{}] {} {} err: {}", new Object[]{id, this.method.name(), this.url(), e.toString()});
                }
                if (e instanceof HttpException) {
                    throw (HttpException)e;
                }
                if (e instanceof HttpClientErrorException) {
                    HttpClientErrorException ee = (HttpClientErrorException)e;
                    throw new HttpException(e).url(this.url()).method(this.method).status(ee.getStatusCode());
                }
                throw new HttpException(e).url(this.url()).method(this.method);
            }
        }

        private String url() {
            return (RestTemplateClient.this.root == null ? "" : RestTemplateClient.this.root) + (this.path == null ? "" : this.path);
        }
    }

    public static class Path
    extends RuntimeException {
        private String encoding = "utf-8";
        private StringBuilder buff = new StringBuilder();
        private boolean alreadyQuery = false;

        private Path() {
        }

        public static Path builder() {
            return new Path();
        }

        public static Path builder(String encoding) {
            Path p = new Path();
            p.encoding = encoding;
            return p;
        }

        public String build() {
            return this.buff.toString();
        }

        public Path append(String value) {
            this.buff.append(value);
            return this;
        }

        public Path pathVariable(String value) {
            this.buff.append(this.encode(value));
            return this;
        }

        public Path query(String key, String value) {
            if (!this.alreadyQuery) {
                this.alreadyQuery = this.buff.toString().contains("?");
            }
            this.buff.append(this.alreadyQuery ? (char)'&' : '?');
            this.buff.append(this.encode(key)).append('=').append(this.encode(value));
            this.alreadyQuery = true;
            return this;
        }

        private String encode(String value) {
            if (value == null) {
                return "";
            }
            if ("".equals(value)) {
                return "";
            }
            try {
                return URLEncoder.encode(value, this.encoding);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("unable to encode " + value, e);
            }
        }
    }

    public static class HttpException
    extends RuntimeException {
        private String url = null;
        private HttpMethod method = null;
        private HttpHeaders headers = null;
        private HttpStatusCode status = null;
        private Object body = null;
        private Throwable error = null;

        public HttpException(Throwable throwable) {
            this.error = throwable;
        }

        public HttpException(ResponseEntity entity) {
            this.headers = entity.getHeaders();
            this.status = entity.getStatusCode();
            this.body = entity.getBody();
        }

        public HttpException url(String value) {
            this.url = value;
            return this;
        }

        public HttpException method(HttpMethod value) {
            this.method = value;
            return this;
        }

        public HttpException status(HttpStatusCode value) {
            this.status = value;
            return this;
        }

        @JsonIgnore
        public HttpHeaders getHeaders() {
            return this.headers;
        }

        public HttpStatusCode getStatus() {
            return this.status;
        }

        @JsonIgnore
        public Object getBody() {
            return this.body;
        }

        @JsonIgnore
        public Throwable getError() {
            return this.error;
        }

        public String getUrl() {
            return this.url;
        }

        public HttpMethod getMethod() {
            return this.method;
        }

        @Override
        public String getMessage() {
            StringBuilder sb = new StringBuilder();
            sb.append("request failed -");
            if (this.method != null) {
                sb.append(" ").append(this.method);
            }
            if (this.url != null) {
                sb.append(" to ").append(this.url);
            }
            if (this.status != null) {
                sb.append(" status: ").append(this.status);
            }
            if (this.error != null) {
                sb.append(" because of: ").append(this.error.toString());
            }
            return sb.toString();
        }
    }

    public static class Builder {
        private String root;
        private RestTemplate template = null;
        private BiFunction<String, Object, HttpHeaders> headers = null;
        private Predicate<ResponseEntity> responseValidator = null;

        public static Builder instance() {
            return new Builder();
        }

        public Builder root(String value) {
            this.root = value;
            return this;
        }

        public Builder template(RestTemplate value) {
            this.template = value;
            return this;
        }

        public Builder headers(BiFunction<String, Object, HttpHeaders> value) {
            this.headers = value;
            return this;
        }

        public Builder responseValidator(Predicate<ResponseEntity> value) {
            this.responseValidator = value;
            return this;
        }

        public RestTemplateClient client() {
            if (this.template == null) {
                throw new IllegalStateException("No template");
            }
            RestTemplateClient client = new RestTemplateClient();
            client.root = this.root;
            client.template = this.template;
            client.responseValidator = this.responseValidator;
            client.headers = this.headers;
            return client;
        }
    }
}

