/*
 * Decompiled with CFR 0.152.
 */
package sk.antons.script;

import java.util.ArrayList;
import java.util.List;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import sk.antons.script.FindMains;
import sk.antons.script.Fs;

@Mojo(name="script", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyResolution=ResolutionScope.RUNTIME)
public class ScriptMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    protected MavenProject project;
    @Parameter(defaultValue="${localRepository}", readonly=true, required=true)
    protected ArtifactRepository localRepository;
    @Parameter(property="destination", defaultValue="${script.destination}", required=false)
    protected String destination;
    @Parameter(property="filename", defaultValue="${script.name}", required=false)
    protected String filename;
    @Parameter(property="includeTest", defaultValue="${script.includeTest}", required=false)
    protected String includeTest;
    @Parameter(property="includeRepo", defaultValue="${script.includeRepo}", required=false)
    protected String includeRepo;
    @Parameter(property="exec", defaultValue="${script.exec}", required=false)
    protected String executable;
    @Parameter(property="shell", defaultValue="${script.shell}", required=false)
    protected String shell;
    @Parameter(property="unix", defaultValue="${script.unix}", required=false)
    protected String unix;
    @Parameter(property="windows", defaultValue="${script.windows}", required=false)
    protected String windows;
    @Parameter(property="pack", defaultValue="${script.pack}", required=false)
    protected String pack;

    protected static String initProperty(String value, String defaultValue) {
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    protected void initProperties() {
        this.destination = ScriptMojo.initProperty(this.destination, "target/script");
        this.filename = ScriptMojo.initProperty(this.filename, this.project.getArtifactId());
        this.includeTest = ScriptMojo.initProperty(this.includeTest, "false");
        this.includeRepo = ScriptMojo.initProperty(this.includeRepo, "false");
        this.shell = ScriptMojo.initProperty(this.shell, "/bin/bash");
        this.unix = ScriptMojo.initProperty(this.unix, "true");
        this.windows = ScriptMojo.initProperty(this.windows, "false");
        this.pack = ScriptMojo.initProperty(this.pack, "false");
    }

    protected void printConf() {
        this.getLog().info((CharSequence)("[script] conf destination: " + this.destination));
        this.getLog().info((CharSequence)("[script] conf name: " + this.filename));
        this.getLog().info((CharSequence)("[script] conf includeTest: " + this.includeTest));
        this.getLog().info((CharSequence)"");
    }

    protected boolean includeTest() {
        return "true".equals(this.includeTest);
    }

    protected boolean includeRepo() {
        return "true".equals(this.includeRepo);
    }

    protected boolean unix() {
        return "true".equals(this.unix);
    }

    protected boolean windows() {
        return "true".equals(this.windows);
    }

    protected boolean pack() {
        return "true".equals(this.pack);
    }

    public void execute() throws MojoExecutionException {
        this.initProperties();
        this.printConf();
        try {
            StringBuilder content;
            List items;
            FindMains mains = FindMains.instance();
            if (this.includeTest() && (items = this.project.getTestCompileSourceRoots()) != null) {
                for (String item : items) {
                    mains.find(item);
                }
            }
            if ((items = this.project.getCompileSourceRoots()) != null) {
                for (String item : items) {
                    mains.find(item);
                }
            }
            ArrayList<String> cp = new ArrayList<String>();
            if (this.includeRepo()) {
                if (this.includeTest()) {
                    ScriptMojo.mergeResouce(cp, this.project.getTestResources());
                }
                ScriptMojo.mergeResouce(cp, this.project.getResources());
            }
            if (this.includeTest()) {
                ScriptMojo.merge(cp, this.project.getTestClasspathElements());
            }
            ScriptMojo.merge(cp, this.project.getCompileClasspathElements());
            if (this.pack()) {
                String repo = this.localRepository.getBasedir();
                String local = this.project.getBasedir().getAbsolutePath();
                ArrayList<String> arrayList = new ArrayList<String>();
                for (String string2 : cp) {
                    String dest = string2;
                    if (dest.startsWith(repo)) {
                        dest = "repo" + dest.substring(repo.length());
                    } else if (dest.startsWith(local)) {
                        dest = "project" + dest.substring(local.length());
                    }
                    if (dest.startsWith("/")) {
                        dest = dest.substring(1);
                    }
                    String newname = "lib/" + dest;
                    Fs.copy(string2, this.destination + "/" + newname);
                    arrayList.add(newname);
                }
                cp = arrayList;
            }
            if (this.unix()) {
                content = new StringBuilder();
                boolean first = true;
                for (String string4 : cp) {
                    if (first) {
                        content.append("-cp \"");
                        first = false;
                    } else {
                        content.append("\n:");
                    }
                    content.append(string4).append('\\');
                }
                content.append("\n\"");
                Fs.save(this.destination + "/" + this.filename + "-cp.arg", "utf-8", content.toString());
            }
            if (this.windows()) {
                content = new StringBuilder();
                boolean first = true;
                for (String string : cp) {
                    if (first) {
                        content.append("-cp \"");
                        first = false;
                    } else {
                        content.append("\n;");
                    }
                    content.append(string.replace('/', '\\').replace("\\", "\\\\")).append('\\');
                }
                content.append("\n\"");
                Fs.save(this.destination + "/win-" + this.filename + "-cp.arg", "utf-8", content.toString());
            }
            if (this.unix()) {
                content = new StringBuilder();
                if (!"".equals(this.shell)) {
                    content.append("#!").append(this.shell).append('\n');
                }
                content.append('\n');
                for (String string : mains.mains()) {
                    content.append("# java @" + this.filename + "-cp.arg ").append(string).append(" \"$@\"\n");
                }
                if (this.executable != null) {
                    content.append("java @" + this.filename + "-cp.arg ").append(this.executable).append(" \"$@\"\n");
                }
                content.append('\n');
                String fname2 = this.destination + "/" + this.filename + ".sh";
                Fs.save(fname2, "utf-8", content.toString());
                Fs.makeExecutable(fname2);
            }
            if (this.windows()) {
                content = new StringBuilder();
                content.append("@echo off\n");
                content.append('\n');
                for (String string : mains.mains()) {
                    content.append("rem java @win-" + this.filename + "-cp.arg ").append(string).append(" %*\n");
                }
                if (this.executable != null) {
                    content.append("java @win-" + this.filename + "-cp.arg ").append(this.executable).append(" %*\n");
                }
                content.append('\n');
                String fname = this.destination + "/" + this.filename + ".bat";
                Fs.save(fname, "utf-8", content.toString());
            }
            if (this.unix()) {
                content = new StringBuilder();
                if (!"".equals(this.shell)) {
                    content.append("#!").append(this.shell).append('\n');
                }
                content.append('\n');
                boolean first = true;
                for (String string : cp) {
                    if (first) {
                        content.append("CLASSPATH=");
                        first = false;
                    } else {
                        content.append("CLASSPATH=$CLASSPATH:");
                    }
                    content.append(string).append('\n');
                }
                content.append("export CLASSPATH\n");
                content.append('\n');
                for (String string : mains.mains()) {
                    content.append("# java ").append(string).append(" \"$@\"\n");
                }
                if (this.executable != null) {
                    content.append("java ").append(this.executable).append(" \"$@\"\n");
                }
                content.append('\n');
                String string = this.destination + "/" + this.filename + "-old.sh";
                Fs.save(string, "utf-8", content.toString());
                Fs.makeExecutable(string);
            }
            if (this.windows()) {
                content = new StringBuilder();
                content.append("@echo off\n");
                content.append('\n');
                boolean first = true;
                for (String string : cp) {
                    if (first) {
                        content.append("set CLASSPATH=");
                        first = false;
                    } else {
                        content.append("set CLASSPATH=%CLASSPATH%;");
                    }
                    content.append(string.replace('/', '\\')).append('\n');
                }
                content.append('\n');
                for (String string : mains.mains()) {
                    content.append("rem java ").append(string).append(" %*\n");
                }
                if (this.executable != null) {
                    content.append("java ").append(this.executable).append(" %*\n");
                }
                content.append('\n');
                String string = this.destination + "/" + this.filename + "-old.bat";
                Fs.save(string, "utf-8", content.toString());
            }
            this.getLog().info((CharSequence)("[script] script generated in " + this.destination));
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static void merge(List<String> target, List<String> source) {
        if (target == null) {
            return;
        }
        if (source == null) {
            return;
        }
        for (String string : source) {
            if (target.contains(string)) continue;
            target.add(string);
        }
    }

    private static void mergeResouce(List<String> target, List<Resource> source) {
        if (target == null) {
            return;
        }
        if (source == null) {
            return;
        }
        for (Resource string : source) {
            if (target.contains(string.getDirectory())) continue;
            target.add(string.getDirectory());
        }
    }
}

