/*
 * Decompiled with CFR 0.152.
 */
package sk.antons.siutils.file;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.integration.file.DirectoryScanner;
import org.springframework.integration.file.FileLocker;
import org.springframework.integration.file.filters.AcceptOnceFileListFilter;
import org.springframework.integration.file.filters.CompositeFileListFilter;
import org.springframework.integration.file.filters.FileListFilter;
import org.springframework.integration.file.filters.IgnoreHiddenFileListFilter;
import org.springframework.util.Assert;

public class RealHeadDirectoryScanner
implements DirectoryScanner {
    private volatile FileListFilter<File> filter;
    private volatile FileLocker locker;
    private int maxFileSizePerList = 100;

    public RealHeadDirectoryScanner(int maxFileSizePerList) {
        this.maxFileSizePerList = maxFileSizePerList;
        ArrayList<Object> defaultFilters = new ArrayList<Object>(2);
        defaultFilters.add(new IgnoreHiddenFileListFilter());
        defaultFilters.add(new AcceptOnceFileListFilter());
        this.filter = new CompositeFileListFilter(defaultFilters);
    }

    public void setFilter(FileListFilter<File> filter) {
        Assert.isTrue((filter == null || filter.supportsSingleFileFiltering() ? 1 : 0) != 0, (String)("filter must support dingke file filtering" + filter));
        this.filter = filter;
    }

    protected FileListFilter<File> getFilter() {
        return this.filter;
    }

    public final void setLocker(FileLocker locker) {
        this.locker = locker;
    }

    protected FileLocker getLocker() {
        return this.locker;
    }

    public boolean tryClaim(File file) {
        return this.locker == null || this.locker.lock(file);
    }

    public List<File> listFiles(File directory) {
        List<File> list;
        block8: {
            Stream<Path> stream = Files.list(directory.toPath());
            try {
                list = stream.filter(Objects::nonNull).map(Path::toFile).filter(file -> file.isFile()).filter(file -> this.filter == null ? true : this.filter.accept(file)).limit(this.maxFileSizePerList).collect(Collectors.toList());
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("unable to list files from " + directory, e);
                }
            }
            stream.close();
        }
        return list;
    }
}

