/*
 * Decompiled with CFR 0.152.
 */
package sk.antons.siutils.log;

import java.util.function.Function;
import org.slf4j.Logger;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.MessagingException;
import sk.antons.siutils.handler.MessageConsumer;

public class SlfHandler
extends MessageConsumer {
    Function<Lg, Lg> lgfunction;

    @Override
    protected void accept(Message<?> message) throws MessagingException {
        if (this.lgfunction != null) {
            this.lgfunction.apply(Lg.of(message));
        }
    }

    public SlfHandler(Function<Lg, Lg> lgfunction) {
        this.lgfunction = lgfunction;
    }

    public static SlfHandler of(Function<Lg, Lg> lgfunction) {
        return new SlfHandler(lgfunction);
    }

    public static class Lg {
        private Message<?> message;

        public Lg(Message<?> message) {
            this.message = message;
        }

        public static Lg of(Message<?> message) {
            return new Lg(message);
        }

        public Message<?> message() {
            return this.message;
        }

        public Object payload() {
            return this.message.getPayload();
        }

        public MessageHeaders header() {
            return this.message.getHeaders();
        }

        public Object header(Object key) {
            return this.message.getHeaders().get(key);
        }

        public Lg trace(Logger log, String message, Object ... params) {
            log.trace(message, params);
            return this;
        }

        public Lg debug(Logger log, String message, Object ... params) {
            log.debug(message, params);
            return this;
        }

        public Lg info(Logger log, String message, Object ... params) {
            log.info(message, params);
            return this;
        }

        public Lg warn(Logger log, String message, Object ... params) {
            log.warn(message, params);
            return this;
        }

        public Lg error(Logger log, String message, Object ... params) {
            log.error(message, params);
            return this;
        }
    }
}

