/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.JavaVersion;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public final class JavaVersionUtil {
    private JavaVersionUtil() {
    }

    public static JavaVersion getJavaVersion() {
        List<JavaVersion> list = JavaVersionUtil.getJavaVersionsByVersion(JavaVersion.values(), JavaVersionUtil.getJavaVersionAsInteger());
        int size = JavaVersionUtil.size(list);
        if (size == 1) {
            return list.get(0);
        }
        if (size > 1) {
            final Field[] fs = JavaVersion.class.getDeclaredFields();
            return Collections.max(list, new Comparator<JavaVersion>(){

                @Override
                public int compare(JavaVersion jv1, JavaVersion jv2) {
                    try {
                        return ObjectUtils.compare((Comparable)Double.valueOf(StringUtils.replace((String)StringUtils.substringAfter((String)JavaVersionUtil.getName(JavaVersionUtil.getFieldByValue(fs, jv1)), (String)"_"), (String)"_", (String)".")), (Comparable)Double.valueOf(StringUtils.replace((String)StringUtils.substringAfter((String)JavaVersionUtil.getName(JavaVersionUtil.getFieldByValue(fs, jv2)), (String)"_"), (String)"_", (String)".")));
                    }
                    catch (NumberFormatException e) {
                        return 0;
                    }
                }
            });
        }
        if (size == 0) {
            try {
                Integer major = JavaVersionUtil.getClassMajorNumber();
                if (major != null && Integer.valueOf(major - 44).equals(JavaVersionUtil.getLatestJavaVersionAsInteger())) {
                    return JavaVersion.JAVA_RECENT;
                }
            }
            catch (IOException e) {
                JavaVersionUtil.printStackTrace(e);
            }
        }
        throw new IllegalStateException();
    }

    private static void printStackTrace(Throwable throwable) {
        try {
            Method method = Throwable.class.getDeclaredMethod("printStackTrace", new Class[0]);
            if (method != null) {
                method.setAccessible(true);
            }
            if (method != null && (Modifier.isStatic(method.getModifiers()) || throwable != null)) {
                method.invoke((Object)throwable, new Object[0]);
            }
        }
        catch (IllegalAccessException e) {
            JavaVersionUtil.printStackTrace(e);
        }
        catch (NoSuchMethodException e) {
            JavaVersionUtil.printStackTrace(e);
        }
        catch (InvocationTargetException e) {
            Throwable targetException = e.getTargetException();
            JavaVersionUtil.printStackTrace((Throwable)ObjectUtils.firstNonNull((Object[])new Throwable[]{ExceptionUtils.getRootCause((Throwable)targetException), targetException, ExceptionUtils.getRootCause((Throwable)e), e}));
        }
    }

    private static Integer getClassMajorNumber() throws IOException {
        InputStream is = null;
        FilterInputStream dis = null;
        try {
            is = Object.class.getResourceAsStream("/java/lang/Object.class");
            dis = new DataInputStream(is);
            if (((DataInputStream)dis).readInt() != -889275714) {
                throw new IOException("Invalid Java class");
            }
            ((DataInputStream)dis).readShort();
            Integer n = 0xFFFF & ((DataInputStream)dis).readShort();
            return n;
        }
        finally {
            if (dis != null) {
                dis.close();
            }
            if (is != null) {
                is.close();
            }
        }
    }

    private static Integer getLatestJavaVersionAsInteger() {
        Integer latestVersion = null;
        try {
            Elements elements = JavaVersionUtil.select((Element)Jsoup.parse((URL)new URL("https://www.oracle.com/java/technologies/downloads/archive/"), (int)0), ".icn-chevron-right a");
            String text = null;
            int i = 0;
            while (elements != null && i < elements.size()) {
                text = JavaVersionUtil.text((Element)elements.get(i));
                if (StringUtils.startsWith((CharSequence)text, (CharSequence)"Java SE")) {
                    if (StringUtils.contains((CharSequence)(text = StringUtils.trim((String)StringUtils.substringAfter((String)text, (String)"Java SE"))), (int)32)) {
                        text = StringUtils.substringBefore((String)text, (String)" ");
                    } else if (StringUtils.contains((CharSequence)text, (int)46)) {
                        text = StringUtils.substringAfter((String)text, (String)".");
                    }
                    try {
                        latestVersion = (Integer)ObjectUtils.max((Comparable[])new Integer[]{latestVersion, Integer.valueOf(text)});
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                ++i;
            }
        }
        catch (IOException e) {
            JavaVersionUtil.printStackTrace(e);
        }
        return latestVersion;
    }

    private static Elements select(Element instance, String cssQuery) {
        return instance != null ? instance.select(cssQuery) : null;
    }

    private static String text(Element instance) {
        return instance != null ? instance.text() : null;
    }

    private static List<JavaVersion> getJavaVersionsByVersion(JavaVersion[] jvs, Integer version) {
        ArrayList<JavaVersion> list = null;
        if (jvs != null) {
            String versionToString = null;
            JavaVersion[] javaVersionArray = jvs;
            int n = jvs.length;
            int n2 = 0;
            while (n2 < n) {
                JavaVersion jv = javaVersionArray[n2];
                String toString = JavaVersionUtil.toString(jv);
                if (StringUtils.equals((CharSequence)toString, (CharSequence)(versionToString = JavaVersionUtil.toString(version))) || StringUtils.equals((CharSequence)StringUtils.substringAfter((String)toString, (String)"."), (CharSequence)versionToString)) {
                    if (list == null) {
                        list = new ArrayList<JavaVersion>();
                    }
                    if (!list.contains(jv)) {
                        list.add(jv);
                    }
                }
                ++n2;
            }
        }
        return list;
    }

    private static String toString(Object instance) {
        return instance != null ? instance.toString() : null;
    }

    private static int size(Collection<?> instance) {
        return instance != null ? instance.size() : 0;
    }

    private static String getName(Member instance) {
        return instance != null ? instance.getName() : null;
    }

    private static Field getFieldByValue(Field[] fs, Object value) {
        Field f = null;
        ArrayList<Field> fields = null;
        int i = 0;
        while (fs != null && i < fs.length) {
            f = fs[i];
            if (f != null && Modifier.isStatic(f.getModifiers())) {
                if (fields == null) {
                    fields = new ArrayList<Field>();
                }
                if (!f.isAccessible()) {
                    f.setAccessible(true);
                }
                try {
                    if (JavaVersionUtil.and(f.get(null) == value, !fields.contains(value))) {
                        fields.add(f);
                    }
                }
                catch (IllegalAccessException e) {
                    JavaVersionUtil.printStackTrace(e);
                }
            }
            ++i;
        }
        int size = JavaVersionUtil.size(fields);
        if (size == 1) {
            return (Field)fields.get(0);
        }
        if (size > 1) {
            throw new IllegalStateException();
        }
        return null;
    }

    private static boolean and(boolean a, boolean b) {
        return a && b;
    }

    private static Integer getJavaVersionAsInteger() {
        LinkedHashMap<Integer, String> map = new LinkedHashMap<Integer, String>(Collections.singletonMap(1, "java.lang.Object"));
        map.put(2, "java.util.Collection");
        map.put(3, "java.lang.reflect.InvocationHandler");
        map.put(4, "java.nio.ByteBuffer");
        map.put(5, "java.lang.ProcessBuilder");
        map.put(6, "java.io.Console");
        map.put(7, "java.nio.file.attribute.FileAttribute");
        map.put(8, "java.util.stream.Stream");
        map.put(9, "java.lang.Module");
        map.put(10, "com.sun.source.doctree.SummaryTree");
        map.put(11, "java.net.http.HttpClient");
        map.put(12, "com.sun.source.doctree.SystemPropertyTree");
        map.put(13, "com.sun.source.util.ParameterNameProvider");
        map.put(14, "java.io.Serial");
        map.put(15, "java.security.interfaces.EdECKey");
        map.put(16, "java.net.UnixDomainSocketAddress");
        map.put(17, "java.util.random.RandomGeneratorFactory");
        map.put(18, "java.net.spi.InetAddressResolver");
        map.put(19, "java.lang.WrongThreadException");
        map.put(20, "java.lang.foreign.Arena");
        Integer result = null;
        for (Map.Entry entry : map.entrySet()) {
            if (entry == null || JavaVersionUtil.forName((String)entry.getValue()) == null) continue;
            result = (Integer)ObjectUtils.max((Comparable[])new Integer[]{result, (Integer)entry.getKey()});
        }
        return result;
    }

    private static Class<?> forName(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }
}

