/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.List;
import javax.lang.model.SourceVersion;

public final class SourceVersionUtil {
    private SourceVersionUtil() {
    }

    public static SourceVersion getJavaVersionAsSourceVersion() {
        int size;
        List<SourceVersion> list = SourceVersionUtil.getJavaVersionAsSourceVersionList(SourceVersion.values());
        int n = size = list != null ? list.size() : 0;
        if (size == 1) {
            return list.get(0);
        }
        if (size > 1) {
            throw new IllegalStateException();
        }
        return null;
    }

    private static List<SourceVersion> getJavaVersionAsSourceVersionList(SourceVersion[] svs) {
        ArrayList<SourceVersion> list = null;
        Integer integer = SourceVersionUtil.getJavaVersionAsInteger();
        if (svs != null && integer != null) {
            String name = null;
            SourceVersion[] sourceVersionArray = svs;
            int n = svs.length;
            int n2 = 0;
            while (n2 < n) {
                SourceVersion sv = sourceVersionArray[n2];
                name = SourceVersionUtil.name(sv);
                if (name != null && name.endsWith(integer.toString())) {
                    if (list == null) {
                        list = new ArrayList<SourceVersion>();
                    }
                    if (!list.contains((Object)sv)) {
                        list.add(sv);
                    }
                }
                ++n2;
            }
        }
        return list;
    }

    private static String name(Enum<?> instance) {
        return instance != null ? instance.name() : null;
    }

    private static Integer getJavaVersionAsInteger() {
        if (SourceVersionUtil.forName("java.io.IO") != null) {
            return 23;
        }
        if (SourceVersionUtil.forName("java.lang.classfile.attribute.ConstantValueAttribute") != null) {
            return 22;
        }
        if (SourceVersionUtil.forName("javax.crypto.KEM") != null) {
            return 21;
        }
        if (SourceVersionUtil.forName("java.lang.foreign.Arena") != null) {
            return 20;
        }
        if (SourceVersionUtil.forName("java.lang.WrongThreadException") != null) {
            return 19;
        }
        if (SourceVersionUtil.forName("java.net.spi.InetAddressResolver") != null) {
            return 18;
        }
        if (SourceVersionUtil.forName("java.util.random.RandomGeneratorFactory") != null) {
            return 17;
        }
        if (SourceVersionUtil.forName("java.net.UnixDomainSocketAddress") != null) {
            return 16;
        }
        if (SourceVersionUtil.forName("java.security.interfaces.EdECKey") != null) {
            return 15;
        }
        if (SourceVersionUtil.forName("java.io.Serial") != null) {
            return 14;
        }
        if (SourceVersionUtil.forName("com.sun.source.util.ParameterNameProvider") != null) {
            return 13;
        }
        if (SourceVersionUtil.forName("com.sun.source.doctree.SystemPropertyTree") != null) {
            return 12;
        }
        if (SourceVersionUtil.forName("java.net.http.HttpClient") != null) {
            return 11;
        }
        if (SourceVersionUtil.forName("com.sun.source.doctree.SummaryTree") != null) {
            return 10;
        }
        if (SourceVersionUtil.forName("java.lang.Module") != null) {
            return 9;
        }
        if (SourceVersionUtil.forName("java.util.stream.Stream") != null) {
            return 8;
        }
        if (SourceVersionUtil.forName("java.nio.file.attribute.FileAttribute") != null) {
            return 7;
        }
        if (SourceVersionUtil.forName("java.io.Console") != null) {
            return 6;
        }
        if (SourceVersionUtil.forName("java.lang.ProcessBuilder") != null) {
            return 5;
        }
        return SourceVersionUtil.getJavaVersionAsInteger1();
    }

    private static Integer getJavaVersionAsInteger1() {
        if (SourceVersionUtil.forName("java.nio.ByteBuffer") != null) {
            return 4;
        }
        if (SourceVersionUtil.forName("java.lang.reflect.InvocationHandler") != null) {
            return 3;
        }
        if (SourceVersionUtil.forName("java.util.Collection") != null) {
            return 2;
        }
        if (SourceVersionUtil.forName("java.lang.Object") != null) {
            return 1;
        }
        return null;
    }

    private static Class<?> forName(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }
}

