/*
 * Decompiled with CFR 0.152.
 */
public final class JavaVersionUtil {
    private JavaVersionUtil() {
    }

    public static int getJavaVersionAsInt() {
        Integer integer = JavaVersionUtil.getJavaVersionAsInteger();
        if (integer != null) {
            return integer;
        }
        throw new IllegalStateException();
    }

    public static Integer getJavaVersionAsInteger() {
        if (JavaVersionUtil.forName("javax.crypto.KDF") != null) {
            return 24;
        }
        if (JavaVersionUtil.forName("java.io.IO") != null) {
            return 23;
        }
        if (JavaVersionUtil.forName("java.lang.classfile.attribute.ConstantValueAttribute") != null) {
            return 22;
        }
        if (JavaVersionUtil.forName("javax.crypto.KEM") != null) {
            return 21;
        }
        if (JavaVersionUtil.forName("java.lang.foreign.Arena") != null) {
            return 20;
        }
        if (JavaVersionUtil.forName("java.lang.WrongThreadException") != null) {
            return 19;
        }
        if (JavaVersionUtil.forName("java.net.spi.InetAddressResolver") != null) {
            return 18;
        }
        if (JavaVersionUtil.forName("java.util.random.RandomGeneratorFactory") != null) {
            return 17;
        }
        if (JavaVersionUtil.forName("java.net.UnixDomainSocketAddress") != null) {
            return 16;
        }
        if (JavaVersionUtil.forName("java.security.interfaces.EdECKey") != null) {
            return 15;
        }
        if (JavaVersionUtil.forName("java.io.Serial") != null) {
            return 14;
        }
        if (JavaVersionUtil.forName("com.sun.source.util.ParameterNameProvider") != null) {
            return 13;
        }
        if (JavaVersionUtil.forName("com.sun.source.doctree.SystemPropertyTree") != null) {
            return 12;
        }
        if (JavaVersionUtil.forName("java.net.http.HttpClient") != null) {
            return 11;
        }
        if (JavaVersionUtil.forName("com.sun.source.doctree.SummaryTree") != null) {
            return 10;
        }
        if (JavaVersionUtil.forName("java.lang.Module") != null) {
            return 9;
        }
        if (JavaVersionUtil.forName("java.util.stream.Stream") != null) {
            return 8;
        }
        if (JavaVersionUtil.forName("java.nio.file.attribute.FileAttribute") != null) {
            return 7;
        }
        return JavaVersionUtil.getJavaVersionAsInteger1();
    }

    private static Integer getJavaVersionAsInteger1() {
        if (JavaVersionUtil.forName("java.io.Console") != null) {
            return 6;
        }
        if (JavaVersionUtil.forName("java.lang.ProcessBuilder") != null) {
            return 5;
        }
        if (JavaVersionUtil.forName("java.nio.ByteBuffer") != null) {
            return 4;
        }
        if (JavaVersionUtil.forName("java.lang.reflect.InvocationHandler") != null) {
            return 3;
        }
        if (JavaVersionUtil.forName("java.util.Collection") != null) {
            return 2;
        }
        if (JavaVersionUtil.forName("java.lang.Object") != null) {
            return 1;
        }
        return null;
    }

    private static Class<?> forName(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }
}

