package com.sentray.kmmprotocolmodule

//actual fun <T> freeze(t: T): T = t

import com.sentray.kmmprotocolmodule.utilityToolKit.loggerKit.KMMLogger
import io.ktor.client.*
import io.ktor.client.engine.okhttp.*
import java.util.concurrent.TimeUnit

actual typealias KMMContext = android.content.Context
actual typealias KMMApplication = android.app.Application

actual object KmmApplicationCache {
    internal actual var kmmApplication: KMMApplication? = null
    actual fun injectApplication(application: KMMApplication) {
        kmmApplication = application
    }

    internal actual fun getContext(): KMMContext? {
        kmmApplication ?: run {
            KMMLogger.e("Please call [KmmApplicationCache.injectApplication(application)] first!!")
        }
        return kmmApplication?.applicationContext
    }
}

actual fun httpClient(config: HttpClientConfig<*>.() -> Unit) = HttpClient(OkHttp) {
    config(this)

    engine {
        config {
            retryOnConnectionFailure(true)
            connectTimeout(0, TimeUnit.SECONDS)
        }
    }
}