package com.sentray.kmmprotocolmodule.network.udp

import kotlinx.coroutines.CoroutineScope
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.delay
import kotlinx.coroutines.launch
import java.net.DatagramPacket
import java.net.DatagramSocket
import java.net.InetAddress
import java.net.InetSocketAddress

internal actual class PlatformUdpClient actual constructor() {
    private var udpClient: DatagramSocket = DatagramSocket()
    private var broadcastAddress: String = ""
    private val receiveTimeout = 100
    private var receiveCallback: ((message: String) -> Unit)? = null
    private var startReceive = false

    init {
        udpClient = DatagramSocket(InetSocketAddress(0))
        udpClient.soTimeout = receiveTimeout
    }

    actual fun setReceiveCallback(callback: (message: String) -> Unit) {
        receiveCallback = callback
    }

    actual fun broadcastPackage(
        broadcastAddress: String,
        broadcastPort: Int,
        broadcastMessage: String
    ): Boolean {
        this.broadcastAddress = broadcastAddress
        var result = false
        if (!udpClient.isClosed) {
            val udpSendByteArray = broadcastMessage.toByteArray()
            val sendPackage = DatagramPacket(udpSendByteArray, udpSendByteArray.count())
            sendPackage.address = InetAddress.getByName(broadcastAddress)
            sendPackage.port = broadcastPort

            udpClient.broadcast = true
            try {
                if (!udpClient.isClosed) {
                    udpClient.send(sendPackage)
                    result = true
                }
            } catch (e: Exception) {
                e.printStackTrace()
            }
            startReceiveCheck()
        }
        return result
    }

    private fun tryReceivePackage(): String? {
        var message: String? = null
        try {
            val buf = ByteArray(2048)
            val packet = DatagramPacket(buf, buf.count())
            packet.address = InetAddress.getByName(broadcastAddress)
            udpClient.receive(packet)
            message = String(buf, 0, packet.length)
        } catch (e: Exception) {
//            KMMLogger.d("UDP 接收错误 : ${e.localizedMessage}")
        }
        return message
    }

    actual fun disconnect() {
        udpClient.disconnect()
        startReceive = false
        stopReceiveCheck()
    }

    private fun startReceiveCheck() {
        if (!startReceive) {
            startReceive = true
            CoroutineScope(Dispatchers.IO).launch {
                while (startReceive) {
                    tryReceivePackage()?.let {
                        receiveCallback?.invoke(it)
                    }
                    delay(100)
                }
            }
        }
    }

    private fun stopReceiveCheck() {
        startReceive = false
    }
}