package com.sentray.kmmprotocolmodule.cryptor.common

import kotlin.experimental.xor

internal class RC4Encoder(key: ByteArray) {
    private val encoder: RC4 = RC4(key)
    private val decoder: RC4 = RC4(key)

    fun decode(data: ByteArray, offset: Int, len: Int): ByteArray {
        return decoder.flip(data, offset, len)
    }

    fun encode(data: ByteArray, offset: Int, len: Int): ByteArray {
        return encoder.flip(data, offset, len)
    }

    internal inner class RC4(key: ByteArray) {
        private val S = ByteArray(256)
        private val T = ByteArray(256)
        private var keyLength = 0
        var i = 0
        var j = 0
        var k = 0
        var t = 0
        var tmp: Byte = 0
        fun flip(plaintext: ByteArray, offset: Int, len: Int): ByteArray {
            val cipher = ByteArray(len)
            for (counter in 0 until len) {
                i = i + 1 and 0xFF
                j = j + S[i] and 0xFF
                tmp = S[j]
                S[j] = S[i]
                S[i] = tmp
                t = S[i] + S[j] and 0xFF
                k = S[t].toInt()
                cipher[counter] = plaintext[counter + offset] xor k.toByte()
            }
            return cipher
        }

        init {
            require(!(key.isEmpty() || key.size > 256)) { "key must be between 1 and 256 bytes" }
            keyLength = key.size
            for (i in 0..255) {
                S[i] = i.toByte()
                T[i] = key[i % keyLength]
            }
            var j = 0
            var tmp: Byte
            for (i in 0..255) {
                j = j + S[i] + T[i] and 0xFF
                tmp = S[j]
                S[j] = S[i]
                S[i] = tmp
            }
        }
    }
}