package com.sentray.kmmprotocolmodule.cryptor.common.hash.sha

import com.sentray.kmmprotocolmodule.cryptor.common.hash.Hash
import com.sentray.kmmprotocolmodule.cryptor.common.hash.MultipartHash

/**
 * Created by Ugljesa Jovanovic
 * ugljesa.jovanovic@ionspin.com
 * on 24-May-2020
 */
internal object Sha512Properties {
    const val MAX_HASH_BYTES = 64
}

internal interface Sha512Multipart : MultipartHash {
    override val MAX_HASH_BYTES: Int
        get() = Sha256Properties.MAX_HASH_BYTES
}

@OptIn(ExperimentalUnsignedTypes::class)
internal interface Sha512 : Hash {
    override val MAX_HASH_BYTES: Int
        get() = Sha512Properties.MAX_HASH_BYTES

    fun digest(
        inputMessage: UByteArray = ubyteArrayOf()
    ): UByteArray
}
