package com.sentray.kmmprotocolmodule.dababase

import com.sentray.kmmprotocolmodule.dababase.model.UpdatedInfo
import com.sentray.kmmprotocolmodule.dababase.model.WiFiDeviceModel
import com.sentray.kmmprotocolmodule.sdk.parser.parserResult.ParserResult
import kotlinx.coroutines.ExperimentalCoroutinesApi
import kotlinx.coroutines.sync.Mutex
import kotlinx.coroutines.sync.withLock

internal object KMMDatabase {

    //增加 lock，保证 wifiDeviceModelMap 单线程读写
    private val mutex = Mutex(locked = false)
    private val wifiDeviceModelMap: MutableMap<String, WiFiDeviceModel> = mutableMapOf()

    internal suspend fun databaseUpdate(parserResult: ParserResult): UpdatedInfo? {
        var updatedInfo: UpdatedInfo? = null
        //1. 遍历本次更新涉及到的中控
        parserResult.baseInfo?.sn?.let { sn ->
            mutex.withLock {
                wifiDeviceModelMap[sn]?.let { wiFiDeviceModel ->
                    //2. 解析ParserResult
                    updatedInfo = wiFiDeviceModel.parse(parserResult)
                }
            }
        }
        return updatedInfo
    }

    suspend fun getWiFiDeviceModel(sn: String): WiFiDeviceModel? {
        mutex.withLock {
            return wifiDeviceModelMap[sn]
        }
    }

    suspend fun removeWiFiDeviceModel(sn: String) {
        mutex.withLock {
            wifiDeviceModelMap.remove(sn)
        }
    }
}