package com.sentray.kmmprotocolmodule.network.smartlink

enum class EOSType {
    IOS,
    Android
}

typealias SuccessCallback = (mac: String, ip: String) -> Unit
typealias FailureCallback = (message: String) -> Unit
typealias FinishCallback = () -> Unit

internal expect class SmartLinkManager {
    companion object {
        fun startSmartLink(
            ssid: String,
            pwd: String,
            timeoutSeconds: Long,
            successCallback: SuccessCallback,
            failureCallback: FailureCallback,
            finishCallback: FinishCallback
        )
    }
}