package com.sentray.kmmprotocolmodule.sdk.command

import com.sentray.kmmprotocolmodule.sdk.parser.parserResult.ControllableApplianceInfo
import com.sentray.kmmprotocolmodule.tcpProtocol.protocolContent.enumDefinition.ENetworkType
import com.sentray.kmmprotocolmodule.tcpProtocol.protocolContent.enumDefinition.ProtocolVersion
import com.sentray.kmmprotocolmodule.tcpProtocol.protocolCreator.CommandData
import com.sentray.kmmprotocolmodule.tcpProtocol.protocolCreator.GetInfoCmdCreator
import kotlin.jvm.JvmStatic

//状态获取命令
class GetInfoCmd {
    companion object {
        //查询命令
        @JvmStatic
        fun getAllInfoCmd(
            sn: String,
            protocolVersion: ProtocolVersion = ProtocolVersion.V2,
            networkType: ENetworkType = ENetworkType.Cloud
        ): CommandData {
            return GetInfoCmdCreator.getAllInfo(
                sn,
                protocolVersion = protocolVersion,
                networkType = networkType
            )
        }

        @JvmStatic
        fun getApplianceStatusCmd(
            controllableApplianceInfo: ControllableApplianceInfo,
            protocolVersion: ProtocolVersion = ProtocolVersion.V2,
            networkType: ENetworkType = ENetworkType.Cloud
        ): CommandData {
            return GetInfoCmdCreator.getApplianceStatus(
                controllableApplianceInfo.sn,
                controllableApplianceInfo.devType,
                controllableApplianceInfo.applianceIndex,
                protocolVersion = protocolVersion,
                networkType = networkType
            )
        }
    }
}