package com.sentray.kmmprotocolmodule.tcpProtocol.protocolContent.paraContent

import com.sentray.kmmprotocolmodule.tcpProtocol.definition.deviceType.DeviceTypeSet
import com.sentray.kmmprotocolmodule.tcpProtocol.protocolContent.enumDefinition.OnOffStatus
import com.sentray.kmmprotocolmodule.tcpProtocol.protocolContent.enumDefinition.ProtocolKey
import com.sentray.kmmprotocolmodule.tcpProtocol.protocolParser.parserUtil.value
import com.sentray.kmmprotocolmodule.utilityToolKit.HexToolKit
import kotlinx.serialization.Serializable
import kotlinx.serialization.json.JsonObject

@Serializable
internal class DevicePara {
    var rfInstall: List<Boolean>? = null
    var index: Int? = null
    var onlineStatus: List<Boolean>? = null
    var rlyStatus: List<Boolean>? = null
    var rlyAction: List<Boolean>? = null
    var rlyMask: List<Boolean>? = null
    var ledStatus: List<Boolean>? = null
    var ledMask: List<Boolean>? = null
    var onOffStatus: List<OnOffStatus>? = null
    var onOffRlyMask: List<Boolean>? = null
    var brightAction: List<Boolean>? = null
    var brightMask: List<Boolean>? = null
    var tempAction: List<Boolean>? = null
    var tempMask: List<Boolean>? = null
    var functionCode: Int? = null
    var functionCodeMask: List<Boolean>? = null
    var brightPercent: List<Int>? = null
    var brightPercentMask: List<Boolean>? = null
    var slowRlyAction: List<Boolean>? = null
    var confMask: List<Boolean>? = null
    var turnOnBrightPercent: List<Int>? = null
    var turnOnMode: List<Int>? = null
    var minBrightPercent: List<Int>? = null
    var brightAdjSpeed: List<Int>? = null
    var onOffBrightAdjSpeed: List<Int>? = null
    var slowlyOnBrightAdjSpeed: List<Int>? = null
    var slowlyOffBrightAdjSpeed: List<Int>? = null
    var powerOnStatus: List<OnOffStatus>? = null
    var needAck: Int? = null
    var devType: DeviceTypeSet? = null
    var curtainAction: List<Int>? = null
    var curtainMask: List<Boolean>? = null
    var para: List<Int>? = null
    var paraMask: List<Boolean>? = null
    var panelAddr: List<Int>? = null
    var panelAction: List<Int>? = null
    var power: List<Int>? = null
    var ver: FirmwareVersion? = null

    fun initialFromRaw(jsonObject: JsonObject, devType: DeviceTypeSet) {
        this.devType = devType

        jsonObject.value<String>(ProtocolKey.RfInstall.raw)?.let {
            this.rfInstall = HexToolKit.hexStringToBoolList(it)
        }
        jsonObject.value<Int>(ProtocolKey.Index.raw)?.let {
            this.index = it
        }
        jsonObject.value<String>(ProtocolKey.OnlineStatus.raw)?.let {
            this.onlineStatus = HexToolKit.hexStringToBoolList(it)
        }
        jsonObject.value<String>(ProtocolKey.RlyStatus.raw)?.let {
            this.rlyStatus = HexToolKit.hexStringToBoolList(it)
        }
        jsonObject.value<String>(ProtocolKey.RlyAction.raw)?.let {
            this.rlyAction = HexToolKit.hexStringToBoolList(it)
        }
        jsonObject.value<String>(ProtocolKey.RlyMask.raw)?.let {
            this.rlyMask = HexToolKit.hexStringToBoolList(it)
        }
        jsonObject.value<String>(ProtocolKey.LedStatus.raw)?.let {
            this.ledStatus = HexToolKit.hexStringToBoolList(it)
        }
        jsonObject.value<String>(ProtocolKey.LedMask.raw)?.let {
            this.ledMask = HexToolKit.hexStringToBoolList(it)
        }

        //onOffStatus & onOffRlyMask 只用于 momson 类型，两个 bit 存储一个设备的上电状态
        jsonObject.value<String>(ProtocolKey.OnOffRlyMask.raw)?.let {
            this.onOffRlyMask = HexToolKit.hexStringToBoolList(it)
        }

        jsonObject.value<String>(ProtocolKey.OnOffStatus.raw)?.let { hexString ->
            HexToolKit.hexStringToBoolList(hexString, 64)?.let { onOffStatusRawList ->
                val onOffStatusNew = mutableListOf<OnOffStatus>()
                (0 until 64 step 2).forEach { index ->
                    //00 上电关
                    if (!onOffStatusRawList[index] && !onOffStatusRawList[index + 1]) {
                        onOffStatusNew.add(OnOffStatus.Off)
                    }
                    //01 上电开
                    else if (onOffStatusRawList[index] && !onOffStatusRawList[index + 1]) {
                        onOffStatusNew.add(OnOffStatus.On)
                    }
                    //10 上电跟随断电前状态
                    else if (!onOffStatusRawList[index] && onOffStatusRawList[index + 1]) {
                        onOffStatusNew.add(OnOffStatus.Follow)
                    }
                    //11 备用
                    else {
                        onOffStatusNew.add(OnOffStatus.Reserve)
                    }
                }

                this.onOffStatus = onOffStatusNew.toList()
            }
        }

        jsonObject.value<String>(ProtocolKey.BrightAction.raw)?.let {
            this.brightAction = HexToolKit.hexStringToBoolList(it)
        }
        jsonObject.value<String>(ProtocolKey.BrightMask.raw)?.let {
            this.brightMask = HexToolKit.hexStringToBoolList(it)
        }
        jsonObject.value<String>(ProtocolKey.TempAction.raw)?.let {
            this.tempAction = HexToolKit.hexStringToBoolList(it)
        }
        jsonObject.value<String>(ProtocolKey.TempMask.raw)?.let {
            this.tempMask = HexToolKit.hexStringToBoolList(it)
        }
        jsonObject.value<Int>(ProtocolKey.FunctionCode.raw)?.let {
            this.functionCode = it
        }
        jsonObject.value<String>(ProtocolKey.FunctionCodeMask.raw)?.let {
            this.functionCodeMask = HexToolKit.hexStringToBoolList(it)
        }
        jsonObject.value<List<Int>>(ProtocolKey.BrightPercent.raw)?.let {
            this.brightPercent = it
        }
        jsonObject.value<String>(ProtocolKey.BrightPercentMask.raw)?.let {
            this.brightPercentMask = HexToolKit.hexStringToBoolList(it)
        }
        jsonObject.value<String>(ProtocolKey.SlowRlyAction.raw)?.let {
            this.slowRlyAction = HexToolKit.hexStringToBoolList(it)
        }
        jsonObject.value<String>(ProtocolKey.ConfMask.raw)?.let {
            this.confMask = HexToolKit.hexStringToBoolList(it)
        }
        jsonObject.value<List<Int>>(ProtocolKey.TurnOnBrightPercent.raw)?.let {
            this.turnOnBrightPercent = it
        }
        jsonObject.value<List<Int>>(ProtocolKey.TurnOnMode.raw)?.let {
            this.turnOnMode = it
        }
        jsonObject.value<List<Int>>(ProtocolKey.MinBrightPercent.raw)?.let {
            this.minBrightPercent = it
        }
        jsonObject.value<List<Int>>(ProtocolKey.BrightAdjSpeed.raw)?.let {
            this.brightAdjSpeed = it
        }
        jsonObject.value<List<Int>>(ProtocolKey.OnOffBrightAdjSpeed.raw)?.let {
            this.onOffBrightAdjSpeed = it
        }
        jsonObject.value<List<Int>>(ProtocolKey.SlowlyOnBrightAdjSpeed.raw)?.let {
            this.slowlyOnBrightAdjSpeed = it
        }
        jsonObject.value<List<Int>>(ProtocolKey.SlowlyOffBrightAdjSpeed.raw)?.let {
            this.slowlyOffBrightAdjSpeed = it
        }
        jsonObject.value<List<Int>>(ProtocolKey.PowerOnStatus.raw)?.let { powerOnStatusRawList ->
            val powerOnStatusNew = mutableListOf<OnOffStatus>()
            powerOnStatusRawList.forEach {
                OnOffStatus.fromRaw(it)?.let { onOffStatus ->
                    powerOnStatusNew.add(onOffStatus)
                }
            }
            this.powerOnStatus = powerOnStatusNew.toList()
        }
        jsonObject.value<Int>(ProtocolKey.NeedAck.raw)?.let {
            this.needAck = it
        }

//        jsonObject.value<String>(ProtocolKey.DevType.raw)?.let {
//            DeviceTypeSet.fromRaw(it)?.let { deviceType ->
//                this.devType = deviceType
//            }
//        }
        jsonObject.value<List<Int>>(ProtocolKey.CurtainAction.raw)?.let {
            this.curtainAction = it
        }
        jsonObject.value<String>(ProtocolKey.CurtainMask.raw)?.let {
            this.curtainMask = HexToolKit.hexStringToBoolList(it)
        }
        jsonObject.value<List<Int>>(ProtocolKey.Para.raw)?.let {
            this.para = it
        }
        jsonObject.value<String>(ProtocolKey.ParaMask.raw)?.let {
            this.paraMask = HexToolKit.hexStringToBoolList(it)
        }
        jsonObject.value<List<Int>>(ProtocolKey.PanelAddr.raw)?.let {
            this.panelAddr = it
        }
        jsonObject.value<List<Int>>(ProtocolKey.PanelAction.raw)?.let {
            this.panelAction = it
        }
        jsonObject.value<List<Int>>(ProtocolKey.Power.raw)?.let {
            this.power = it
        }
        jsonObject.value<String>(ProtocolKey.Ver.raw)?.let { fwVerString ->
            this.ver = FirmwareVersion().also { it.initialFromString(fwVerString) }
        }
    }
}