package com.sentray.kmmprotocolmodule.tcpProtocol.protocolContent.paraContent

import kotlinx.serialization.Serializable

@Serializable
class FirmwareVersion {
    var major: Int = 0
    var minor: Int = 0
    var build: Int = 0


    //1.1.1
    fun initialFromString(fwVersionString: String) {
        fwVersionString.split(".").let {
            if (it.count() == 3) {
                it[0].toIntOrNull()?.let { major ->
                    this.major = major
                }
                it[1].toIntOrNull()?.let { minor ->
                    this.minor = minor
                }
                it[2].toIntOrNull()?.let { build ->
                    this.build = build
                }
            }
        }
    }

    fun getString(): String {
        return "$major.$minor.$build"
    }

    fun isNewerThan(fwVersionToCompare: FirmwareVersion): Boolean {
        return if (this.major == fwVersionToCompare.major) {
            if (this.minor == fwVersionToCompare.minor) {
                this.build > fwVersionToCompare.build
            } else {
                this.minor > fwVersionToCompare.minor
            }
        } else {
            this.major > fwVersionToCompare.major
        }
    }

//    fun freezeSelf() {
//        freeze(this)
//    }
}