package com.sentray.kmmprotocolmodule.tcpProtocol.protocolContent.paraContent

import com.sentray.kmmprotocolmodule.tcpProtocol.definition.deviceType.DeviceTypeSet
import com.sentray.kmmprotocolmodule.tcpProtocol.definition.deviceType.DeviceTypeUtil
import com.sentray.kmmprotocolmodule.tcpProtocol.protocolContent.enumDefinition.ProtocolKey
import com.sentray.kmmprotocolmodule.tcpProtocol.protocolParser.parserUtil.value
import com.sentray.kmmprotocolmodule.utilityToolKit.HexToolKit
import kotlinx.serialization.Serializable
import kotlinx.serialization.json.JsonObject

@Serializable
internal class TriggerPara {
    var inputDeviceIndex: Int? = null
    var inputDeviceType: DeviceTypeSet = DeviceTypeSet.Unknown
    var triggerIndex: Int = 0
    var subIndex: Int? = null
    var userActionMask: List<Boolean>? = null
    var defaultActionMask: List<Boolean>? = null
    var triggerStatus: List<Boolean>? = null
    var triggerMask: List<Boolean>? = null
    var delay: Int? = null

    //[inputDeviceIndex, inputDeviceType , triggerIndex,subIndex，actionMask0，actionMask1,defaultActionMask,triggerStatus,triggerMask,delay]
    fun initialFromRawList(triggerParaRawList: List<Long>) {
        if (triggerParaRawList.count() == 10) {
            this.inputDeviceIndex = triggerParaRawList[0].toInt()
            DeviceTypeUtil.findDeviceTypeString(triggerParaRawList[1].toInt())
                ?.let { devTypeString ->
                    DeviceTypeSet.fromRaw(devTypeString)?.let {
                        this.inputDeviceType = it
                    }
                }

            this.triggerIndex = triggerParaRawList[2].toInt()
            this.subIndex = triggerParaRawList[3].toInt()

            val actionMask0BoolList =
                HexToolKit.longToBoolList(triggerParaRawList[4].toULong(), 32)
            val actionMask1BoolList = HexToolKit.longToBoolList(triggerParaRawList[5].toULong(), 32)
            val actionMaskBoolList = mutableListOf<Boolean>()
            actionMaskBoolList.addAll(0, actionMask0BoolList)
            actionMaskBoolList.addAll(32, actionMask1BoolList)
            this.userActionMask = actionMaskBoolList.toList()

            this.defaultActionMask = HexToolKit.longToBoolList(triggerParaRawList[6].toULong())
            this.triggerStatus = HexToolKit.longToBoolList(triggerParaRawList[7].toULong())
            this.triggerMask = HexToolKit.longToBoolList(triggerParaRawList[8].toULong())
            this.delay = triggerParaRawList[9].toInt()
        }
    }

    fun initialFromRawJsonObject(jsonObject: JsonObject) {
        //inputDeviceIndex
        jsonObject.value<Long>(ProtocolKey.InputDeviceIndex.raw)?.let {
            this.inputDeviceIndex = it.toInt()
        }

        //inputDeviceType   //TODO: 无需解析

        //triggerIndex
        jsonObject.value<Long>(ProtocolKey.TriggerIndex.raw)?.let {
            this.triggerIndex = it.toInt()
        }
        //subIndex  //TODO: 无需解析

        //userActionMask
        jsonObject.value<String>(ProtocolKey.ActionMask.raw)?.let { hexString ->
            HexToolKit.hexStringToBoolList(hexString)?.let {
                this.userActionMask = it
            }
        }

        //defaultActionMask
        jsonObject.value<String>(ProtocolKey.DefaultActionMask.raw)?.let { hexString ->
            HexToolKit.hexStringToBoolList(hexString)?.let {
                this.defaultActionMask = it
            }
        }

        //triggerStatus
        jsonObject.value<String>(ProtocolKey.TriggerStatus.raw)?.let { hexString ->
            HexToolKit.hexStringToBoolList(hexString)?.let {
                this.triggerStatus = it
            }
        }

        //triggerMask
        jsonObject.value<String>(ProtocolKey.TriggerMask.raw)?.let { hexString ->
            HexToolKit.hexStringToBoolList(hexString)?.let {
                this.triggerMask = it
            }
        }

        //delay
        jsonObject.value<Long>(ProtocolKey.Delay.raw)?.let {
            this.delay = it.toInt()
        }
    }
}