package com.sentray.kmmprotocolmodule.tcpProtocol.protocolCreator

import com.sentray.kmmprotocolmodule.tcpProtocol.definition.deviceType.DeviceTypeSet
import com.sentray.kmmprotocolmodule.tcpProtocol.protocolContent.enumDefinition.*
import com.sentray.kmmprotocolmodule.utilityToolKit.HexToolKit
import io.ktor.util.date.*
import kotlinx.serialization.ExperimentalSerializationApi
import kotlinx.serialization.Serializable
import kotlinx.serialization.encodeToString
import kotlinx.serialization.json.Json
import kotlinx.serialization.json.buildJsonObject
import kotlinx.serialization.json.put
import kotlinx.serialization.json.putJsonObject
import kotlin.jvm.JvmStatic

@OptIn(ExperimentalSerializationApi::class)
internal class GetInfoCmdCreator {
    companion object {
        @Serializable
        private data class GetAllInfoPara(
            val sn: String,
            val seq: Int,
            val factoryID: Int,
            val time: Int,
            val cmd: String,
            val confVer: Int
        )
        //TODO: 貌似所有命令均需要区分局域网和广域网，不能一概而论，否则中控不回复

        //获取中控所有设备信息
        @JvmStatic
        fun getAllInfo(
            sn: String,
            factoryID: FactoryID = FactoryID.WILINK,
            protocolVersion: ProtocolVersion = ProtocolVersion.V2,
            networkType: ENetworkType = ENetworkType.Cloud
        ): CommandData {
            val seq = Util.randomSeq()
            val para = GetAllInfoPara(
                sn,
                seq,
                factoryID.raw,
                (getTimeMillis() / 1000).toInt(),
                Cmd.Get.raw,
                0
            )
            val cmdRaw = Json.encodeToString(para)
            val cmdString = Util.encode(cmdRaw, protocolVersion, networkType)
            return CommandData(seq, cmdString)
        }

        //获取设备状态
        @JvmStatic
        fun getApplianceStatus(
            sn: String,
            deviceTypeSet: DeviceTypeSet,
            applianceIndex: Int,
            factoryID: FactoryID = FactoryID.WILINK,
            protocolVersion: ProtocolVersion = ProtocolVersion.V2,
            networkType: ENetworkType = ENetworkType.Cloud
        ): CommandData {
            val seq = Util.randomSeq()
            val jsonObject = buildJsonObject {
                put(ProtocolKey.Sn.raw, sn)
                put(ProtocolKey.Seq.raw, seq)
                put(ProtocolKey.FactoryID.raw, factoryID.raw)
                put(ProtocolKey.Cmd.raw, Cmd.GetStatus.raw)
                putJsonObject(deviceTypeSet.raw) {
                    val mask = HexToolKit.indexToHexString(applianceIndex)
                    put(ProtocolKey.RlyMask.raw, mask)
                }
            }

            val cmdRaw = Json.encodeToString(jsonObject)
            val cmdString = Util.encode(cmdRaw, protocolVersion, networkType)
            return CommandData(seq, cmdString)
        }
    }
}